/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.entity;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.fastener.AbstractFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FenceFastener;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public final class FenceFastenerEntity
extends HangingEntity
implements IEntityWithComplexSpawn {
    private final FenceFastener fastener = new FenceFastener(this);
    private int surfaceCheckTime;

    public FenceFastenerEntity(EntityType<? extends FenceFastenerEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public FenceFastenerEntity(Level world) {
        this((EntityType<? extends FenceFastenerEntity>)((EntityType)FLEntities.FASTENER.get()), world);
    }

    public FenceFastenerEntity(Level world, BlockPos pos) {
        this(world);
        this.setPos(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getWidth() {
        return 9;
    }

    public int getHeight() {
        return 9;
    }

    public Optional<Fastener<?>> getFastener() {
        return Optional.of(this.fastener);
    }

    public float getEyeHeight(Pose pose, EntityDimensions size) {
        return 1.0f;
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean ignoreExplosion() {
        return true;
    }

    public boolean survives() {
        return !this.level().isLoaded(this.pos) || ConnectionItem.isFence(this.level().getBlockState(this.pos));
    }

    public void remove(Entity.RemovalReason reason) {
        this.getFastener().ifPresent(Fastener::remove);
        super.remove(reason);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide() && this.isAlive()) {
            this.markHurt();
            this.dropItem(source.getEntity());
            this.remove(Entity.RemovalReason.KILLED);
        }
        return true;
    }

    public boolean canChangeDimensions() {
        return false;
    }

    public void dropItem(@Nullable Entity breaker) {
        this.getFastener().ifPresent(fastener -> fastener.dropItems(this.level(), this.pos));
        if (breaker != null) {
            this.level().levelEvent(2001, this.pos, Block.getId((BlockState)((FastenerBlock)((Object)FLBlocks.FASTENER.get())).defaultBlockState()));
        }
    }

    public void playPlacementSound() {
        SoundType sound = ((FastenerBlock)((Object)FLBlocks.FASTENER.get())).getSoundType(((FastenerBlock)((Object)FLBlocks.FASTENER.get())).defaultBlockState(), (LevelReader)this.level(), this.getPos(), null);
        this.playSound(sound.getPlaceSound(), (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
    }

    public SoundSource getSoundSource() {
        return SoundSource.BLOCKS;
    }

    public void setPos(double x, double y, double z) {
        super.setPos((double)Mth.floor((double)x) + 0.5, (double)Mth.floor((double)y) + 0.5, (double)Mth.floor((double)z) + 0.5);
    }

    public void setDirection(Direction facing) {
    }

    protected AABB calculateBoundingBox(BlockPos pos, Direction direction) {
        double posX = (double)pos.getX() + 0.5;
        double posY = (double)pos.getY() + 0.5;
        double posZ = (double)pos.getZ() + 0.5;
        float w = 0.1875f;
        float h = 0.1875f;
        return new AABB(posX - 0.1875, posY - 0.1875, posZ - 0.1875, posX + 0.1875, posY + 0.1875, posZ + 0.1875);
    }

    public AABB getBoundingBoxForCulling() {
        return new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public void tick() {
        this.getFastener().ifPresent(fastener -> {
            if (!this.level().isClientSide() && (fastener.hasNoConnections() || this.checkSurface())) {
                this.dropItem(null);
                this.remove(Entity.RemovalReason.DISCARDED);
            } else if (fastener.update() && !this.level().isClientSide()) {
                UpdateEntityFastenerMessage msg = new UpdateEntityFastenerMessage((Entity)this, fastener.serializeNBT());
                ServerProxy.sendToPlayersWatchingEntity(msg, (Entity)this);
            }
        });
    }

    private boolean checkSurface() {
        if (this.surfaceCheckTime++ == 100) {
            this.surfaceCheckTime = 0;
            return !this.survives();
        }
        return false;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof ConnectionItem) {
            if (this.level().isClientSide()) {
                player.swing(hand);
            } else {
                this.getFastener().ifPresent(fastener -> ((ConnectionItem)stack.getItem()).connect(stack, player, this.level(), (Fastener<?>)fastener));
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        compound.put("fastener", (Tag)this.fastener.serializeNBT());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("pos", 10)) {
            NbtUtils.readBlockPos((CompoundTag)compound, (String)"pos").ifPresent(pos -> {
                this.pos = pos;
            });
        }
        if (compound.contains("fastener", 10)) {
            RegistryAccess.Frozen provider = this.level() != null ? this.level().registryAccess() : RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
            this.fastener.deserializeNBT(compound.getCompound("fastener"), (HolderLookup.Provider)provider);
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                CompoundTag tag = fastener.serializeNBT();
                NbtIo.write((CompoundTag)tag, (DataOutput)new ByteBufOutputStream((ByteBuf)buf));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void readSpawnData(RegistryFriendlyByteBuf buf) {
        this.getFastener().ifPresent(fastener -> {
            try {
                NbtAccounter accounter;
                try {
                    accounter = (NbtAccounter)NbtAccounter.class.getMethod("unlimitedHeap", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Exception e1) {
                    try {
                        accounter = (NbtAccounter)NbtAccounter.class.getMethod("createUnlimited", Integer.TYPE).invoke(null, 0x200000);
                    }
                    catch (Exception e2) {
                        accounter = NbtAccounter.create((long)0x200000L);
                    }
                }
                CompoundTag tag = null;
                try {
                    tag = NbtIo.read((DataInput)new ByteBufInputStream((ByteBuf)buf), (NbtAccounter)accounter);
                }
                catch (Exception e3) {
                    try {
                        tag = NbtIo.read((DataInput)new ByteBufInputStream((ByteBuf)buf));
                    }
                    catch (Exception e4) {
                        tag = new CompoundTag();
                    }
                }
                if (tag != null && fastener instanceof AbstractFastener) {
                    ((AbstractFastener)fastener).deserializeNBT(tag, (HolderLookup.Provider)buf.registryAccess());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static FenceFastenerEntity create(Level world, BlockPos fence) {
        FenceFastenerEntity fastener = new FenceFastenerEntity(world, fence);
        world.addFreshEntity((Entity)fastener);
        fastener.playPlacementSound();
        return fastener;
    }

    @Nullable
    public static FenceFastenerEntity find(Level world, BlockPos pos) {
        HangingEntity entity = FenceFastenerEntity.findHanging(world, pos);
        if (entity instanceof FenceFastenerEntity) {
            return (FenceFastenerEntity)entity;
        }
        return null;
    }

    @Nullable
    public static HangingEntity findHanging(Level world, BlockPos pos) {
        for (HangingEntity e : world.getEntitiesOfClass(HangingEntity.class, new AABB(pos).inflate(2.0))) {
            if (!e.getPos().equals((Object)pos)) continue;
            return e;
        }
        return null;
    }
}

