/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Curve;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractFastener<F extends FastenerAccessor>
implements Fastener<F> {
    private static final Object CONNECTION_MAP_LOCK = new Object();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<UUID, Connection> outgoing = new HashMap<UUID, Connection>();
    private final Map<UUID, Incoming> incoming = new HashMap<UUID, Incoming>();
    protected AABB bounds = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    @Nullable
    private Level world;
    private boolean dirty;
    @Nullable
    private CompoundTag pendingLoadNBT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Connection> get(UUID id) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            return Optional.ofNullable(this.outgoing.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Connection> getOwnConnections() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            return ImmutableList.copyOf(this.outgoing.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Connection> getAllConnections() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            ImmutableList.Builder list = new ImmutableList.Builder();
            list.addAll(this.outgoing.values());
            if (this.world != null) {
                for (Incoming i : this.incoming.values()) {
                    i.get(this.world).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0));
                }
            }
            return list.build();
        }
    }

    @Override
    public AABB getBounds() {
        return this.bounds;
    }

    @Override
    public abstract BlockPos getPos();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorld(Level world) {
        this.world = world;
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            this.outgoing.values().forEach(c -> c.setWorld(world));
        }
        if (world != null && this.pendingLoadNBT != null) {
            CompoundTag nbt = this.pendingLoadNBT;
            this.pendingLoadNBT = null;
            this.deserializeNBT(nbt, (HolderLookup.Provider)world.registryAccess());
        }
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            Iterator<Connection> it = this.outgoing.values().iterator();
            Vec3 fromOffset = this.getConnectionPoint();
            boolean dirty = this.dirty;
            this.dirty = false;
            while (it.hasNext()) {
                Connection connection = it.next();
                if (connection.update(fromOffset)) {
                    dirty = true;
                }
                if (!connection.isRemoved()) continue;
                dirty = true;
                it.remove();
                this.incoming.remove(connection.getUUID());
                if (this.world == null) continue;
                this.drop(this.world, this.getPos(), connection);
            }
            if (this.world != null) {
                this.incoming.values().removeIf(incoming -> incoming.gone(this.world));
            }
            if (dirty) {
                this.calculateBoundingBox();
            }
            return dirty;
        }
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    protected void calculateBoundingBox() {
        if (this.outgoing.isEmpty()) {
            this.bounds = new AABB(this.getPos());
            return;
        }
        AABBBuilder builder = new AABBBuilder();
        for (Connection connection : this.outgoing.values()) {
            Curve catenary = connection.getCatenary();
            if (catenary == null) continue;
            Curve.SegmentIterator it = catenary.iterator();
            while (it.next()) {
                builder.include(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                if (it.hasNext()) continue;
                builder.include(it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f));
            }
        }
        this.bounds = builder.add(this.getConnectionPoint()).build();
    }

    @Override
    public void dropItems(Level world, BlockPos pos) {
        for (Connection connection : this.getAllConnections()) {
            this.drop(world, pos, connection);
        }
    }

    private void drop(Level world, BlockPos pos, Connection connection) {
        if (!connection.shouldDrop()) {
            return;
        }
        float offsetX = world.random.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.random.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.random.nextFloat() * 0.8f + 0.1f;
        ItemStack stack = connection.getItemStack();
        ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.getX() + offsetX), (double)((float)pos.getY() + offsetY), (double)((float)pos.getZ() + offsetZ), stack);
        float scale = 0.05f;
        entityItem.setDeltaMovement(world.random.nextGaussian() * (double)0.05f, world.random.nextGaussian() * (double)0.05f + (double)0.2f, world.random.nextGaussian() * (double)0.05f);
        world.addFreshEntity((Entity)entityItem);
        connection.noDrop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            this.outgoing.values().forEach(Connection::remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNoConnections() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            return this.outgoing.isEmpty() && this.incoming.isEmpty();
        }
    }

    @Override
    public boolean hasConnectionWith(Fastener<?> fastener) {
        return this.getConnectionTo((FastenerAccessor)fastener.createAccessor()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Connection getConnectionTo(FastenerAccessor destination) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            for (Connection connection : this.outgoing.values()) {
                if (!connection.isDestination(destination)) continue;
                return connection;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConnection(UUID uuid) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            Connection connection = this.outgoing.remove(uuid);
            if (connection != null) {
                connection.remove();
                this.setDirty();
                return true;
            }
            if (this.incoming.remove(uuid) != null) {
                this.setDirty();
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean removeConnection(Connection connection) {
        return this.removeConnection(connection.getUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reconnect(Level world, Connection connection, Fastener<?> newDestination) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            if (this.equals(newDestination) || newDestination.hasConnectionWith(this)) {
                return false;
            }
            UUID uuid = connection.getUUID();
            if (connection.getDestination().get(world, false).filter(t -> {
                t.removeConnection(uuid);
                return true;
            }).isPresent()) {
                connection.setDestination(newDestination);
                connection.setDrop();
                newDestination.createIncomingConnection(this.world, uuid, this, connection.getType());
                this.setDirty();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(Level world, Fastener<?> destination, ConnectionType<?> type, CompoundTag compound, boolean drop) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            UUID uuid = Mth.createInsecureUUID();
            Connection connection = this.createOutgoingConnection(world, uuid, destination, type, compound, drop);
            destination.createIncomingConnection(world, uuid, this, type);
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection createOutgoingConnection(Level world, UUID uuid, Fastener<?> destination, ConnectionType<?> type, CompoundTag compound, boolean drop) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            Object c = type.create(world, this, uuid);
            ((Connection)c).deserialize(destination, compound, drop, (HolderLookup.Provider)world.registryAccess());
            this.outgoing.put(uuid, (Connection)c);
            this.setDirty();
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createIncomingConnection(Level world, UUID uuid, Fastener<?> destination, ConnectionType<?> type) {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            this.incoming.put(uuid, new Incoming((FastenerAccessor)destination.createAccessor(), uuid));
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundTag serializeNBT() {
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            CompoundTag compound = new CompoundTag();
            ListTag outgoing = new ListTag();
            LOGGER.error("FL_DEBUG_CRITICAL: AbstractFastener.serializeNBT outgoing size: {}", (Object)this.outgoing.size());
            for (Map.Entry<UUID, Connection> connectionEntry : this.outgoing.entrySet()) {
                UUID uuid = connectionEntry.getKey();
                Connection connection = connectionEntry.getValue();
                CompoundTag connectionCompound = new CompoundTag();
                connectionCompound.put("connection", (Tag)connection.serialize());
                connectionCompound.putString("type", RegistryObjects.getName(FairyLights.CONNECTION_TYPES.get(), connection.getType()).toString());
                connectionCompound.putUUID("uuid", uuid);
                outgoing.add((Object)connectionCompound);
            }
            compound.put("outgoing", (Tag)outgoing);
            ListTag incoming = new ListTag();
            for (Map.Entry<UUID, Incoming> e : this.incoming.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.putUUID("uuid", e.getKey());
                tag.put("fastener", (Tag)FastenerType.serialize(e.getValue().fastener));
                incoming.add((Object)tag);
            }
            compound.put("incoming", (Tag)incoming);
            return compound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeNBT(CompoundTag compound, HolderLookup.Provider provider) {
        if (this.world == null) {
            this.pendingLoadNBT = compound;
            return;
        }
        Object object = CONNECTION_MAP_LOCK;
        synchronized (object) {
            ListTag listConnections = compound.getList("outgoing", 10);
            ArrayList<UUID> nbtUUIDs = new ArrayList<UUID>();
            for (int i = 0; i < listConnections.size(); ++i) {
                CompoundTag connectionCompound = listConnections.getCompound(i);
                UUID uuid = connectionCompound.hasUUID("uuid") ? connectionCompound.getUUID("uuid") : Mth.createInsecureUUID();
                nbtUUIDs.add(uuid);
                if (this.outgoing.containsKey(uuid)) {
                    Connection connection = this.outgoing.get(uuid);
                    CompoundTag connectionTag = connectionCompound.getCompound("connection");
                    LogUtils.getLogger().info("FL_DEBUG: AbstractFastener.deserializeNBT - calling connection.deserialize() for existing connection " + String.valueOf(uuid) + " isOn in NBT=" + String.valueOf(connectionTag.contains("isOn") ? Boolean.valueOf(connectionTag.getBoolean("isOn")) : "MISSING"));
                    connection.deserialize(connectionTag, provider);
                    continue;
                }
                ResourceLocation typeId = ResourceLocation.tryParse((String)connectionCompound.getString("type"));
                ConnectionType type = null;
                if (typeId != null) {
                    try {
                        Registry<ConnectionType<?>> registry = FairyLights.CONNECTION_TYPES.get();
                        ResourceKey key = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)FairyLights.CONNECTION_TYPE), (ResourceLocation)typeId);
                        type = (ConnectionType)registry.get(key);
                    }
                    catch (Exception e) {
                        LOGGER.error("FL_DEBUG: Registry lookup failed for type " + String.valueOf(typeId), (Throwable)e);
                    }
                }
                if (type == null || this.world == null) continue;
                Object connection = type.create(this.world, this, uuid);
                ((Connection)connection).deserialize(connectionCompound.getCompound("connection"), provider);
                this.outgoing.put(uuid, (Connection)connection);
            }
            Iterator<Map.Entry<UUID, Connection>> connectionsIter = this.outgoing.entrySet().iterator();
            while (connectionsIter.hasNext()) {
                Map.Entry<UUID, Connection> connection = connectionsIter.next();
                if (nbtUUIDs.contains(connection.getKey())) continue;
                connectionsIter.remove();
                connection.getValue().remove();
            }
            this.incoming.clear();
            ListTag incoming = compound.getList("incoming", 10);
            for (int i = 0; i < incoming.size(); ++i) {
                CompoundTag incomingNbt = incoming.getCompound(i);
                UUID uuid = incomingNbt.getUUID("uuid");
                FastenerAccessor fastener = FastenerType.deserialize(incomingNbt.getCompound("fastener"));
                this.incoming.put(uuid, new Incoming(fastener, uuid));
            }
            this.setDirty();
        }
    }

    static class Incoming {
        final FastenerAccessor fastener;
        final UUID id;

        Incoming(FastenerAccessor fastener, UUID id) {
            this.fastener = fastener;
            this.id = id;
        }

        boolean gone(Level world) {
            return this.fastener.isGone(world);
        }

        Optional<Connection> get(Level world) {
            return this.fastener.get(world, false).map(Optional::of).orElse(Optional.empty()).flatMap(f -> f.get(this.id));
        }
    }
}

