/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface Fastener<F extends FastenerAccessor> {
    public CompoundTag serializeNBT();

    public void deserializeNBT(CompoundTag var1, HolderLookup.Provider var2);

    public Optional<Connection> get(UUID var1);

    public List<Connection> getOwnConnections();

    public List<Connection> getAllConnections();

    default public Optional<Connection> getFirstConnection() {
        return this.getAllConnections().stream().findFirst();
    }

    public AABB getBounds();

    public Vec3 getConnectionPoint();

    public BlockPos getPos();

    public Direction getFacing();

    public void setWorld(Level var1);

    @Nullable
    public Level getWorld();

    public F createAccessor();

    public boolean isMoving();

    default public void resistSnap(Vec3 from) {
    }

    public boolean update();

    public void setDirty();

    public void dropItems(Level var1, BlockPos var2);

    public void remove();

    public boolean hasNoConnections();

    public boolean hasConnectionWith(Fastener<?> var1);

    @Nullable
    public Connection getConnectionTo(FastenerAccessor var1);

    public boolean removeConnection(UUID var1);

    public boolean removeConnection(Connection var1);

    public boolean reconnect(Level var1, Connection var2, Fastener<?> var3);

    public Connection connect(Level var1, Fastener<?> var2, ConnectionType<?> var3, CompoundTag var4, boolean var5);

    public Connection createOutgoingConnection(Level var1, UUID var2, Fastener<?> var3, ConnectionType<?> var4, CompoundTag var5, boolean var6);

    public void createIncomingConnection(Level var1, UUID var2, Fastener<?> var3, ConnectionType<?> var4);
}

