/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.accessor.PlayerFastenerAccessor;
import me.paulf.fairylights.server.item.ConnectionItem;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public final class PlayerFastener
extends EntityFastener<Player> {
    public PlayerFastener(Player entity) {
        super(entity);
    }

    @Override
    public Vec3 getConnectionPoint() {
        double dy;
        double forwardDist;
        Vec3 point = super.getConnectionPoint();
        if (((Player)this.entity).isFallFlying()) {
            return point;
        }
        double angle = (((Player)this.entity).yBodyRot - 90.0f) * ((float)Math.PI / 180);
        double perpAngle = angle - 1.5707963267948966;
        boolean sneaking = ((Player)this.entity).isCrouching();
        double perpDist = 0.4 * (double)(this.matchesStack(((Player)this.entity).getMainHandItem()) ? 1 : -1);
        if (sneaking) {
            forwardDist = 0.0;
            dy = 0.6;
        } else {
            forwardDist = 0.2;
            dy = 0.8;
        }
        double dx = Math.cos(perpAngle) * perpDist - Math.cos(angle) * forwardDist;
        double dz = Math.sin(perpAngle) * perpDist - Math.sin(angle) * forwardDist;
        return point.add(dx, dy, dz);
    }

    @Override
    public boolean isMoving() {
        return true;
    }

    @Override
    public boolean update() {
        if (!(this.hasNoConnections() || this.matchesStack(((Player)this.entity).getMainHandItem()) || this.matchesStack(((Player)this.entity).getOffhandItem()))) {
            for (Connection connection : this.getAllConnections()) {
                if (connection.shouldDrop()) continue;
                connection.remove();
            }
        }
        return super.update();
    }

    private boolean matchesStack(ItemStack stack) {
        if (!(stack.getItem() instanceof ConnectionItem)) {
            return false;
        }
        ConnectionItem item = (ConnectionItem)stack.getItem();
        return this.getFirstConnection().map(connection -> connection.getType() == item.getConnectionType()).orElse(false);
    }

    @Override
    public void resistSnap(Vec3 from) {
        double dist = this.getConnectionPoint().distanceTo(from);
        if (dist > 32.0) {
            double arcX;
            double arcY;
            double arcZ;
            double dx = ((Player)this.entity).getX() - from.x;
            double dy = ((Player)this.entity).getY() - from.y;
            double dz = ((Player)this.entity).getZ() - from.z;
            double vectorX = dx / dist;
            double vectorY = dy / dist;
            double vectorZ = dz / dist;
            double factor = Math.min((dist - 32.0) / 5.0, 5.0);
            Vec3 motion = ((Player)this.entity).getDeltaMovement();
            double tangent = Math.cos(Mth.atan2((double)dy, (double)Math.sqrt(dx * dx + dz * dz))) * Math.signum(motion.y);
            double speed = motion.length();
            double swing = Math.abs(speed) < 1.0E-6 ? 0.0 : (1.0 - Math.abs(motion.y / speed - tangent)) * 0.1;
            double mag = Math.sqrt(motion.x * motion.x + tangent * tangent + motion.z * motion.z);
            if (dy > 0.0 || Math.abs(mag) < 1.0E-6) {
                arcZ = 0.0;
                arcY = 0.0;
                arcX = 0.0;
            } else {
                arcX = motion.x / mag * swing;
                arcY = tangent / mag * swing;
                arcZ = motion.z / mag * swing;
            }
            ((Player)this.entity).setDeltaMovement(motion.x + vectorX * -Math.abs(vectorX) * factor + arcX, motion.y + vectorY * -Math.abs(vectorY) * factor + arcY, motion.z + vectorZ * -Math.abs(vectorZ) * factor + arcZ);
            ((Player)this.entity).fallDistance = 0.0f;
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(this.entity));
            }
        }
    }

    @Override
    public PlayerFastenerAccessor createAccessor() {
        return new PlayerFastenerAccessor(this);
    }
}

