/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import java.util.Optional;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class BlockFastenerAccessor
implements FastenerAccessor {
    private BlockPos pos = BlockPos.ZERO;

    public BlockFastenerAccessor() {
    }

    public BlockFastenerAccessor(BlockFastener fastener) {
        this(fastener.getPos());
    }

    public BlockFastenerAccessor(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public Optional<Fastener<?>> get(Level world, boolean load) {
        BlockEntity entity = world.getBlockEntity(this.pos);
        return entity != null ? CapabilityHandler.getFastenerCapability(entity) : Optional.empty();
    }

    @Override
    public boolean isGone(Level world) {
        if (world.isClientSide()) {
            return false;
        }
        BlockEntity entity = world.getBlockEntity(this.pos);
        return entity == null || CapabilityHandler.getFastenerCapability(entity).isEmpty();
    }

    @Override
    public FastenerType getType() {
        return FastenerType.BLOCK;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockFastenerAccessor) {
            return this.pos.equals((Object)((BlockFastenerAccessor)obj).pos);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        return tag;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos").orElseGet(() -> {
            CompoundTag posTag;
            if (nbt.contains("pos", 10) && (posTag = nbt.getCompound("pos")).contains("X", 99) && posTag.contains("Y", 99) && posTag.contains("Z", 99)) {
                return new BlockPos(posTag.getInt("X"), posTag.getInt("Y"), posTag.getInt("Z"));
            }
            return BlockPos.ZERO;
        });
    }
}

