/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.EntityFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class EntityFastenerAccessor<E extends Entity>
implements FastenerAccessor {
    private final Class<? extends E> entityClass;
    private UUID uuid;
    @Nullable
    private E entity;
    @Nullable
    private Vec3 pos;

    public EntityFastenerAccessor(Class<? extends E> entityClass) {
        this(entityClass, (UUID)null);
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, EntityFastener<E> fastener) {
        this(entityClass, fastener.getEntity().getUUID());
        this.entity = fastener.getEntity();
        this.pos = this.entity.position();
    }

    public EntityFastenerAccessor(Class<? extends E> entityClass, UUID uuid) {
        this.entityClass = entityClass;
        this.uuid = uuid;
    }

    @Override
    public Optional<Fastener<?>> get(Level world, boolean load) {
        if (this.entity == null) {
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                if (this.entityClass == Player.class) {
                    ServerPlayer p = serverLevel.getServer().getPlayerList().getPlayer(this.uuid);
                    if (p != null) {
                        this.entity = (Entity)this.entityClass.cast(p);
                    }
                } else {
                    Entity e = serverLevel.getEntity(this.uuid);
                    if (this.entityClass.isInstance(e)) {
                        this.entity = (Entity)this.entityClass.cast(e);
                    }
                }
            } else if (this.pos != null) {
                for (Entity entity : world.getEntitiesOfClass(this.entityClass, new AABB(this.pos.subtract(4.0, 4.0, 4.0), this.pos.add(4.0, 4.0, 4.0)))) {
                    if (!this.uuid.equals(entity.getUUID())) continue;
                    this.entity = entity;
                    break;
                }
                if (this.entity == null) {
                    // empty if block
                }
            }
        }
        if (this.entity != null && this.entity.level() == world) {
            this.pos = this.entity.position();
            return CapabilityHandler.getFastenerCapability(this.entity);
        }
        return Optional.empty();
    }

    @Override
    public boolean isGone(Level world) {
        return !world.isClientSide() && this.entity != null && (!CapabilityHandler.getFastenerCapability(this.entity).isPresent() || this.entity.level() != world);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EntityFastenerAccessor) {
            return this.uuid.equals(((EntityFastenerAccessor)obj).uuid);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("UUID", this.uuid);
        if (this.pos != null) {
            ListTag pos = new ListTag();
            pos.add((Object)DoubleTag.valueOf((double)this.pos.x));
            pos.add((Object)DoubleTag.valueOf((double)this.pos.y));
            pos.add((Object)DoubleTag.valueOf((double)this.pos.z));
            tag.put("Pos", (Tag)pos);
        }
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.uuid = tag.getUUID("UUID");
        if (tag.contains("Pos", 9)) {
            ListTag pos = tag.getList("Pos", 6);
            this.pos = new Vec3(pos.getDouble(0), pos.getDouble(1), pos.getDouble(2));
        } else {
            this.pos = null;
        }
        this.entity = null;
    }
}

