/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IncandescentBehavior
implements BrightnessLightBehavior {
    private float prevBrightness = 1.0f;
    private float brightness = 1.0f;
    private boolean powered = true;

    @Override
    public float getBrightness(float delta) {
        return Mth.lerp((float)delta, (float)this.prevBrightness, (float)this.brightness);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
        if (now) {
            this.brightness = this.powered ? 1.0f : 0.0f;
            this.prevBrightness = this.brightness;
        }
    }

    @Override
    public void tick(Level world, Vec3 origin, Light<?> light) {
        this.prevBrightness = this.brightness;
        if (this.powered) {
            this.brighten(1.0f, 0.2f);
        } else {
            this.brighten(0.0f, 0.1f);
        }
        if (this.brightness > 0.85f && world.random.nextFloat() < 0.25f) {
            this.brightness -= world.random.nextFloat() * 0.05f;
        }
    }

    private void brighten(float target, float rate) {
        if (this.brightness != target) {
            this.brightness += (target - this.brightness) * rate;
            if (Math.abs(target - this.brightness) < 0.01f) {
                this.brightness = target;
            }
        }
    }
}

