/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TorchLightBehavior
implements BrightnessLightBehavior {
    private final double offset;
    private float value = 1.0f;
    private boolean powered = true;

    public TorchLightBehavior(double offset) {
        this.offset = offset;
    }

    @Override
    public float getBrightness(float delta) {
        return this.value;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
        this.value = this.powered ? 1.0f : 0.0f;
    }

    @Override
    public void tick(Level world, Vec3 origin, Light<?> light) {
        if (world.random.nextFloat() < 0.08f) {
            this.createParticles(world, origin, light);
        }
    }

    @Override
    public void animateTick(Level world, Vec3 origin, Light<?> light) {
        this.createParticles(world, origin, light);
    }

    private void createParticles(Level world, Vec3 origin, Light<?> light) {
        if (this.powered) {
            Vec3 p = light.getTransformedPoint(origin, new Vec3(0.0, -this.offset, 0.0));
            double x = p.x();
            double y = p.y();
            double z = p.z();
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

