/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.TwinkleLogic;
import me.paulf.fairylights.util.CubicBezier;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TwinkleBehavior
implements BrightnessLightBehavior {
    private static final CubicBezier EASE_IN_OUT = new CubicBezier(0.4f, 0.0f, 0.6f, 1.0f);
    private final TwinkleLogic logic;
    private boolean powered = true;

    public TwinkleBehavior(float chance, int duration) {
        this.logic = new TwinkleLogic(chance, duration);
    }

    @Override
    public float getBrightness(float delta) {
        if (this.powered) {
            float x = this.logic.get(delta);
            return x < 0.25f ? 1.0f - EASE_IN_OUT.eval(x / 0.25f) : EASE_IN_OUT.eval(FLMth.transform(x, 0.25f, 1.0f, 0.0f, 1.0f));
        }
        return 0.0f;
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(Level world, Vec3 origin, Light<?> light) {
        this.logic.tick(world.random, this.powered);
    }

    public static boolean exists(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        return !tag.isEmpty() && tag.getBoolean("twinkle");
    }
}

