/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.integration.jei;

import me.paulf.fairylights.server.item.FLDataComponents;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ColorSubtypeInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    private static final Logger LOGGER = LogManager.getLogger();

    public String apply(ItemStack stack, UidContext context) {
        StringBuilder sb = new StringBuilder();
        if (stack.has((DataComponentType)FLDataComponents.COLOR.get()) && !stack.has((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get())) {
            sb.append(String.format("C:%06x", stack.get((DataComponentType)FLDataComponents.COLOR.get())));
        }
        if (stack.has((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get())) {
            CompoundTag compoundTag = (CompoundTag)stack.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
        }
        if (sb.length() > 0) {
            String result = sb.toString();
            if (BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath().equals("hanging_lights")) {
                LOGGER.info("ColorSubtypeInterpreter: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())) + " -> " + result);
            }
            return result;
        }
        return "";
    }
}

