/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.paulf.fairylights.server.integration.jei.ColorSubtypeInterpreter;
import me.paulf.fairylights.server.integration.jei.GenericRecipeWrapper;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@JeiPlugin
public final class FairyLightsJEIPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogManager.getLogger();

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"plugin");
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        LOGGER.info("FairyLightsJEIPlugin: Registering GenericRecipeWrapper extension");
        registration.getCraftingCategory().addExtension(GenericRecipe.class, (ICraftingCategoryExtension)new GenericRecipeWrapper());
    }

    public void registerRecipes(IRecipeRegistration registration) {
        LOGGER.info("FairyLightsJEIPlugin: Registering recipes");
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            LOGGER.error("FairyLightsJEIPlugin: ClientLevel is null during recipe registration!");
            return;
        }
        RecipeManager recipeManager = world.getRecipeManager();
        ArrayList allRecipes = new ArrayList(recipeManager.getRecipes());
        LOGGER.info("FairyLightsJEIPlugin: RecipeManager contains " + allRecipes.size() + " total recipes.");
        Map<String, Long> recipesByNamespace = allRecipes.stream().collect(Collectors.groupingBy(h -> h.id().getNamespace(), Collectors.counting()));
        LOGGER.info("FairyLightsJEIPlugin: Recipe counts by namespace:");
        recipesByNamespace.forEach((ns, count) -> LOGGER.info(" - " + ns + ": " + count));
        List<RecipeHolder> fairylightsRecipes = allRecipes.stream().filter(holder -> holder.id().getNamespace().equals("fairylights")).filter(holder -> holder.value() instanceof GenericRecipe).map(holder -> holder).collect(Collectors.toList());
        LOGGER.info("FairyLightsJEIPlugin: Found " + fairylightsRecipes.size() + " GenericRecipes to register.");
        fairylightsRecipes.forEach(holder -> LOGGER.info(" - Registering GenericRecipe: " + String.valueOf(holder.id())));
        registration.addRecipes(RecipeTypes.CRAFTING, fairylightsRecipes);
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        System.out.println("DEBUG: FairyLightsJEIPlugin.registerItemSubtypes called!");
        LOGGER.info("FairyLightsJEIPlugin: Registering item subtypes");
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.HANGING_LIGHTS.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.PENNANT_BUNTING.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.TINSEL.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.TRIANGLE_PENNANT.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.SPEARHEAD_PENNANT.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.SWALLOWTAIL_PENNANT.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)FLItems.SQUARE_PENNANT.get()), (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter());
        FLItems.lights().forEach(i -> registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)i, (IIngredientSubtypeInterpreter)new ColorSubtypeInterpreter()));
    }
}

