/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import me.paulf.fairylights.util.FLMth;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.ingredient.AuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.EmptyRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.GenericIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class GenericRecipeWrapper
implements ICraftingCategoryExtension<GenericRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    private GenericRecipe recipe;
    private List<List<ItemStack>> allInputs;
    private List<List<ItemStack>> minimalInputStacks;
    private List<ItemStack> outputs;
    private GenericIngredient<?, ?>[] ingredientMatrix;
    private int subtypeIndex;

    public GenericRecipeWrapper() {
    }

    public GenericRecipeWrapper(GenericRecipe recipe) {
        this.recipe = recipe;
    }

    private void forOutputMatches(BiConsumer<ItemStack, ItemStack> outputConsumer) {
        if (this.subtypeIndex == -1) {
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>(this.minimalInputStacks.size());
            for (List<ItemStack> stacks : this.minimalInputStacks) {
                inputStacks.add(stacks.isEmpty() ? ItemStack.EMPTY : stacks.get(0));
            }
            CraftingInput input = CraftingInput.of((int)this.getWidth(), (int)this.getHeight(), inputStacks);
            if (this.recipe.matches(input, null)) {
                outputConsumer.accept(ItemStack.EMPTY, this.recipe.assemble(input, null));
            }
        } else {
            List<ItemStack> dictators = this.minimalInputStacks.get(this.subtypeIndex);
            for (ItemStack subtype : dictators) {
                ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>(this.minimalInputStacks.size());
                for (int i = 0; i < this.minimalInputStacks.size(); ++i) {
                    if (i == this.subtypeIndex) {
                        inputStacks.add(subtype);
                        continue;
                    }
                    List<ItemStack> stacks = this.minimalInputStacks.get(i);
                    inputStacks.add(stacks.isEmpty() ? ItemStack.EMPTY : stacks.get(0));
                }
                CraftingInput input = CraftingInput.of((int)this.getWidth(), (int)this.getHeight(), inputStacks);
                if (!this.recipe.matches(input, null)) continue;
                outputConsumer.accept(subtype, this.recipe.assemble(input, null));
            }
        }
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public Input getInputsForOutput(ItemStack output) {
        RegularIngredient[] ingredients = this.recipe.getGenericIngredients();
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(9);
        GenericIngredient[] ingredientMat = new GenericIngredient[9];
        AuxiliaryIngredient<?>[] aux = this.recipe.getAuxiliaryIngredients();
        try {
            int auxIngIdx = 0;
            int auxIdx = 0;
            for (int i = 0; i < 9; ++i) {
                ImmutableList<ImmutableList<ItemStack>> ingInputs;
                int x = i % 3;
                int y = i / 3;
                RegularIngredient ingredient = null;
                if (x < this.recipe.getWidth() && y < this.recipe.getHeight()) {
                    ingredient = ingredients[x + y * this.recipe.getWidth()];
                    ingInputs = ingredient.getInput(output);
                    if ((ingInputs == null || ingInputs.isEmpty()) && ingredient != null && !(ingredient instanceof EmptyRegularIngredient)) {
                        LOGGER.warn("GenericRecipeWrapper: Failed to get inputs for ingredient at index " + i + " for " + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.recipe.getSerializer())));
                    }
                } else {
                    ingInputs = null;
                }
                if (ingInputs == null || ingInputs.isEmpty()) {
                    boolean isEmpty = true;
                    if (auxIngIdx < aux.length) {
                        ImmutableList<ImmutableList<ItemStack>> auxInputs = null;
                        AuxiliaryIngredient<?> ingredientAux = null;
                        while (auxIngIdx < aux.length && (auxInputs = (ingredientAux = aux[auxIngIdx]).getInput(output)).size() <= 0) {
                            ++auxIngIdx;
                        }
                        if (auxInputs.size() > 0) {
                            inputs.add((List)auxInputs.get(auxIdx++));
                            ingredientMat[i] = ingredientAux;
                            if (auxIdx == auxInputs.size()) {
                                auxIdx = 0;
                                ++auxIngIdx;
                            }
                            isEmpty = false;
                        }
                    }
                    if (!isEmpty) continue;
                    inputs.add(Collections.emptyList());
                    continue;
                }
                inputs.add((List)ingInputs.get(0));
                ingredientMat[i] = ingredient;
            }
        }
        catch (Exception e) {
            LOGGER.error("GenericRecipeWrapper: Exception deriving inputs for " + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getKey(this.recipe.getSerializer())), (Throwable)e);
            return new Input(Collections.emptyList(), new GenericIngredient[9]);
        }
        return new Input(inputs, ingredientMat);
    }

    @Nullable
    private Input getInputsForIngredient(ItemStack ingredient) {
        for (int i = 0; i < this.allInputs.size(); ++i) {
            List<ItemStack> options = this.allInputs.get(i);
            ItemStack matched = null;
            for (ItemStack o : options) {
                if (ingredient.getItem() != o.getItem()) continue;
                matched = ingredient.copy();
                matched.setCount(1);
                break;
            }
            if (matched == null) continue;
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>(this.minimalInputStacks.size());
            for (int n = 0; n < this.minimalInputStacks.size(); ++n) {
                List<ItemStack> stacks = this.minimalInputStacks.get(n);
                inputStacks.add(i == n ? matched : (stacks.isEmpty() ? ItemStack.EMPTY : stacks.get(0)));
            }
            CraftingInput input = CraftingInput.of((int)this.getWidth(), (int)this.getHeight(), inputStacks);
            if (!this.recipe.matches(input, null)) continue;
            ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(this.allInputs.size());
            for (int n = 0; n < this.allInputs.size(); ++n) {
                List<ItemStack> stacks = this.allInputs.get(n);
                inputs.add(i == n ? Collections.singletonList(matched) : stacks);
            }
            return new Input(inputs, this.ingredientMatrix);
        }
        return null;
    }

    public List<ItemStack> getOutput(List<List<ItemStack>> inputs) {
        int size = 1;
        for (List<ItemStack> stack : inputs) {
            if (stack.size() <= 0) continue;
            size = FLMth.lcm(stack.size(), size);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int n = 0; n < size; ++n) {
            ArrayList<ItemStack> inputStacks = new ArrayList<ItemStack>(inputs.size());
            for (int i = 0; i < inputs.size(); ++i) {
                List<ItemStack> stacks = inputs.get(i);
                inputStacks.add(stacks.isEmpty() ? ItemStack.EMPTY : stacks.get(n % stacks.size()));
            }
            CraftingInput input = CraftingInput.of((int)this.getWidth(), (int)this.getHeight(), inputStacks);
            if (!this.recipe.matches(input, null)) continue;
            outputs.add(this.recipe.assemble(input, null));
        }
        return outputs;
    }

    public void setRecipe(RecipeHolder<GenericRecipe> recipeHolder, IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        GenericRecipe recipe = (GenericRecipe)recipeHolder.value();
        LOGGER.info("GenericRecipeWrapper: setRecipe called for " + String.valueOf(recipeHolder.id()));
        this.recipe = recipe;
        ArrayList<List<ItemStack>> allInputs = new ArrayList<List<ItemStack>>();
        ArrayList<List<ItemStack>> minimalInputStacks = new ArrayList<List<ItemStack>>();
        RegularIngredient[] ingredients = recipe.getGenericIngredients();
        AuxiliaryIngredient<?>[] aux = recipe.getAuxiliaryIngredients();
        this.ingredientMatrix = new GenericIngredient[9];
        int subtypeIndex = -1;
        int auxIdx = 0;
        for (int i = 0; i < 9; ++i) {
            GenericIngredient<RegularIngredient, GenericRecipe.MatchResultRegular> ingredient;
            int x = i % 3;
            int y = i / 3;
            boolean isEmpty = true;
            if (x < recipe.getWidth() && y < recipe.getHeight()) {
                ingredient = ingredients[x + y * recipe.getWidth()];
                ImmutableList<ItemStack> ingInputs = ingredient.getInputs();
                if (ingInputs.size() > 0) {
                    if (ingredient.dictatesOutputType()) {
                        minimalInputStacks.add((List<ItemStack>)ingInputs);
                        subtypeIndex = i;
                    } else {
                        minimalInputStacks.add((List<ItemStack>)ImmutableList.of((Object)((ItemStack)ingInputs.get(0))));
                    }
                    this.ingredientMatrix[i] = ingredient;
                    allInputs.add((List<ItemStack>)ingInputs);
                    isEmpty = false;
                } else {
                    LOGGER.warn("GenericRecipeWrapper: Ingredient at " + i + " returned empty inputs! " + String.valueOf(ingredient));
                }
            }
            if (!isEmpty) continue;
            ingredient = null;
            ImmutableList stacks = null;
            boolean dictator = false;
            while (auxIdx < aux.length) {
                ImmutableList a;
                if ((a = (ingredient = aux[auxIdx++]).getInputs()).size() <= 0) continue;
                stacks = a;
                if (!ingredient.dictatesOutputType()) break;
                subtypeIndex = i;
                dictator = true;
                break;
            }
            if (stacks == null) {
                stacks = ImmutableList.of();
                ingredient = null;
            }
            minimalInputStacks.add((List<ItemStack>)(stacks.isEmpty() || dictator ? stacks : ImmutableList.of((Object)((ItemStack)stacks.get(0)))));
            this.ingredientMatrix[i] = ingredient;
            allInputs.add((List<ItemStack>)stacks);
        }
        this.allInputs = allInputs;
        this.minimalInputStacks = minimalInputStacks;
        this.subtypeIndex = subtypeIndex;
        ImmutableList.Builder outputs = ImmutableList.builder();
        this.forOutputMatches((v, output) -> outputs.add(output));
        this.outputs = outputs.build();
        LOGGER.info("GenericRecipeWrapper: Generated " + this.outputs.size() + " outputs for " + String.valueOf(recipeHolder.id()));
        if (builder != null && craftingGridHelper != null && focuses != null) {
            LOGGER.info("GenericRecipeWrapper: interacting with builder");
            this.setRecipe(builder, craftingGridHelper, focuses);
        } else {
            LOGGER.warn("GenericRecipeWrapper: builder or helper is null!");
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ICraftingGridHelper craftingGridHelper, IFocusGroup focuses) {
        focuses.getFocuses((IIngredientType)VanillaTypes.ITEM_STACK).flatMap(focus -> {
            ItemStack stack = (ItemStack)focus.getTypedValue().getIngredient();
            Input input = null;
            if (focus.getRole() == RecipeIngredientRole.INPUT) {
                input = this.getInputsForIngredient(stack);
            } else if (focus.getRole() == RecipeIngredientRole.OUTPUT) {
                input = this.getInputsForOutput(stack);
            }
            return Stream.ofNullable(input);
        }).findFirst().ifPresentOrElse(input -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.getOutput(input.inputs));
            List slots = craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, input.inputs, this.getWidth(), this.getHeight());
            for (int i = 0; i < 9; ++i) {
                GenericIngredient<?, ?> ingredient = input.ingredients[i];
                if (ingredient == null) continue;
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)slots.get(i);
                slot.addTooltipCallback((recipeSlotView, tooltip) -> {
                    if (recipeSlotView.getRole() == RecipeIngredientRole.INPUT) {
                        ingredient.addTooltip(tooltip);
                    }
                });
            }
        }, () -> {
            craftingGridHelper.createAndSetOutputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.outputs);
            craftingGridHelper.createAndSetInputs(builder, (IIngredientType)VanillaTypes.ITEM_STACK, this.allInputs, this.getWidth(), this.getHeight());
        });
    }

    private static final class Input {
        List<List<ItemStack>> inputs;
        GenericIngredient<?, ?>[] ingredients;

        private Input(List<List<ItemStack>> inputs, GenericIngredient<?, ?>[] ingredients) {
            this.inputs = inputs;
            this.ingredients = ingredients;
        }
    }
}

