/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Optional;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.GarlandTinselConnection;
import me.paulf.fairylights.server.connection.GarlandVineConnection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.LetterBuntingConnection;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredHolder;

public abstract class ConnectionItem
extends Item {
    private final DeferredHolder<ConnectionType<?>, ? extends ConnectionType<?>> type;

    public ConnectionItem(Item.Properties properties, DeferredHolder<ConnectionType<?>, ? extends ConnectionType<?>> type) {
        super(properties);
        this.type = type;
    }

    public final ConnectionType<?> getConnectionType() {
        return (ConnectionType)this.type.get();
    }

    public InteractionResult useOn(UseOnContext context) {
        HangingEntity entity;
        Player user = context.getPlayer();
        if (user == null) {
            return super.useOn(context);
        }
        Level world = context.getLevel();
        Direction side = context.getClickedFace();
        BlockPos clickPos = context.getClickedPos();
        Block fastener = (Block)FLBlocks.FASTENER.get();
        ItemStack stack = context.getItemInHand();
        if (this.isConnectionInOtherHand(world, user, stack)) {
            return InteractionResult.PASS;
        }
        BlockState fastenerState = (BlockState)fastener.defaultBlockState().setValue((Property)FastenerBlock.FACING, (Comparable)side);
        BlockState currentBlockState = world.getBlockState(clickPos);
        BlockPlaceContext blockContext = new BlockPlaceContext(context);
        BlockPos placePos = blockContext.getClickedPos();
        if (currentBlockState.getBlock() == fastener) {
            if (!world.isClientSide()) {
                this.connect(stack, user, world, clickPos);
            }
            return InteractionResult.SUCCESS;
        }
        if (blockContext.canPlace() && fastenerState.canSurvive((LevelReader)world, placePos)) {
            if (!world.isClientSide()) {
                this.connect(stack, user, world, placePos, fastenerState);
            }
            return InteractionResult.SUCCESS;
        }
        if (ConnectionItem.isFence(currentBlockState) && ((entity = FenceFastenerEntity.findHanging(world, clickPos)) == null || entity instanceof FenceFastenerEntity)) {
            if (!world.isClientSide()) {
                this.connectFence(stack, user, world, clickPos, (FenceFastenerEntity)entity);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean isConnectionInOtherHand(Level world, Player user, ItemStack stack) {
        Optional<Fastener<?>> attacherOpt = CapabilityHandler.getFastenerCapability((Entity)user);
        if (attacherOpt.isEmpty()) {
            return false;
        }
        Fastener<?> attacher = attacherOpt.get();
        Optional<Connection> connOpt = attacher.getFirstConnection();
        if (connOpt.isEmpty()) {
            return false;
        }
        Connection connection = connOpt.get();
        CompoundTag logic = connection.serializeLogic();
        this.removeBackups((Tag)logic);
        CompoundTag stackTag = ConnectionItem.getData(stack);
        if (stackTag == null) {
            // empty if block
        }
        if (stackTag != null && !logic.contains("color") && stackTag.contains("color")) {
            stackTag.remove("color");
        }
        if (logic.isEmpty()) {
            return stackTag != null && !stackTag.isEmpty();
        }
        if (stackTag == null || stackTag.isEmpty()) {
            if (connection instanceof GarlandTinselConnection) {
                int defaultColor = DyeableItem.getColor(DyeColor.LIGHT_GRAY);
                if (logic.contains("color", 3) && logic.getInt("color") == defaultColor && logic.size() == 1) {
                    return false;
                }
            } else if (connection instanceof PennantBuntingConnection) {
                CompoundTag textTag;
                boolean hasEmptyPattern = !logic.contains("pattern", 9) || logic.contains("pattern", 9) && logic.getList("pattern", 10).isEmpty();
                boolean hasEmptyText = true;
                if (logic.contains("text", 10) && (textTag = logic.getCompound("text")).contains("value", 8)) {
                    hasEmptyText = textTag.getString("value").isEmpty();
                }
                if (hasEmptyPattern && hasEmptyText) {
                    return false;
                }
            } else if (connection instanceof HangingLightsConnection) {
                boolean hasEmptyPattern;
                boolean hasDefaultString = logic.contains("string", 8) && logic.getString("string").equals("fairylights:black_string");
                boolean bl = hasEmptyPattern = !logic.contains("pattern", 9) || logic.contains("pattern", 9) && logic.getList("pattern", 10).isEmpty();
                if (hasDefaultString && hasEmptyPattern && logic.size() == 2) {
                    return false;
                }
            } else if (connection instanceof LetterBuntingConnection) {
                boolean hasEmptyText;
                boolean bl = hasEmptyText = !logic.contains("text", 10) || logic.contains("text", 10) && (logic.getCompound("text").isEmpty() || logic.getCompound("text").contains("value", 8) && logic.getCompound("text").getString("value").isEmpty());
                if (hasEmptyText) {
                    return false;
                }
            } else if (connection instanceof GarlandVineConnection && logic.isEmpty()) {
                return false;
            }
            return true;
        }
        boolean logicImpliesStack = Utils.impliesNbt((Tag)logic, (Tag)stackTag);
        boolean stackImpliesLogic = Utils.impliesNbt((Tag)stackTag, (Tag)logic);
        boolean matches = logicImpliesStack && stackImpliesLogic;
        return !matches;
    }

    private static CompoundTag getData(ItemStack stack) {
        CompoundTag tag = ((CompoundTag)stack.getOrDefault((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)new CompoundTag())).copy();
        if (stack.has((DataComponentType)FLDataComponents.COLOR.get()) && !tag.contains("color")) {
            tag.putInt("color", ((Integer)stack.get((DataComponentType)FLDataComponents.COLOR.get())).intValue());
        }
        if (stack.has((DataComponentType)FLDataComponents.STYLED_STRING.get()) && !tag.contains("text")) {
            tag.put("text", (Tag)stack.get((DataComponentType)FLDataComponents.STYLED_STRING.get()));
        }
        return tag.isEmpty() ? null : tag;
    }

    private void removeBackups(Tag tag) {
        block3: {
            block2: {
                if (!(tag instanceof CompoundTag)) break block2;
                CompoundTag compound = (CompoundTag)tag;
                compound.remove("fl_backup_color");
                for (String key : compound.getAllKeys()) {
                    this.removeBackups(compound.get(key));
                }
                break block3;
            }
            if (!(tag instanceof ListTag)) break block3;
            ListTag list = (ListTag)tag;
            for (int i = 0; i < list.size(); ++i) {
                this.removeBackups(list.get(i));
            }
        }
    }

    private void connect(ItemStack stack, Player user, Level world, BlockPos pos) {
        BlockEntity entity = world.getBlockEntity(pos);
        if (entity != null) {
            CapabilityHandler.getFastenerCapability(entity).ifPresent(fastener -> this.connect(stack, user, world, (Fastener<?>)fastener));
        }
    }

    private void connect(ItemStack stack, Player user, Level world, BlockPos pos, BlockState state) {
        if (world.setBlock(pos, state, 3)) {
            state.getBlock().setPlacedBy(world, pos, state, (LivingEntity)user, stack);
            SoundType sound = state.getBlock().getSoundType(state, (LevelReader)world, pos, (Entity)user);
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity != null) {
                CapabilityHandler.getFastenerCapability(entity).ifPresent(destination -> this.connect(stack, user, world, (Fastener<?>)destination, false));
            }
        }
    }

    public void connect(ItemStack stack, Player user, Level world, Fastener<?> fastener) {
        this.connect(stack, user, world, fastener, true);
    }

    public void connect(ItemStack stack, Player user, Level world, Fastener<?> fastener, boolean playConnectSound) {
        CapabilityHandler.getFastenerCapability((Entity)user).ifPresent(attacher -> {
            boolean playSound = playConnectSound;
            Optional<Connection> placing = attacher.getFirstConnection();
            if (placing.isPresent()) {
                Connection conn = placing.get();
                boolean ok = conn.reconnect(fastener);
                if (ok) {
                    conn.onConnect(world, user, stack);
                    stack.shrink(1);
                    ConnectionItem.syncFastenerBlock(world, conn.getFastener());
                    ConnectionItem.syncFastenerBlock(world, fastener);
                } else {
                    playSound = false;
                }
            } else {
                CompoundTag data = ConnectionItem.getData(stack);
                if (data == null) {
                    CompoundTag empty = new CompoundTag();
                    fastener.connect(world, (Fastener<?>)attacher, this.getConnectionType(), empty, false);
                } else {
                    CompoundTag dataCopy = data.copy();
                    fastener.connect(world, (Fastener<?>)attacher, this.getConnectionType(), dataCopy, false);
                }
                ConnectionItem.syncFastenerBlock(world, fastener);
            }
            if (playSound) {
                Vec3 pos = fastener.getConnectionPoint();
                world.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)FLSounds.CORD_CONNECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        });
    }

    private static void syncFastenerBlock(Level world, Fastener<?> fastener) {
        if (world == null || world.isClientSide() || fastener == null) {
            return;
        }
        if (!(fastener instanceof BlockFastener)) {
            return;
        }
        BlockPos pos = fastener.getPos();
        BlockState state = world.getBlockState(pos);
        BlockEntity be = world.getBlockEntity(pos);
        if (be != null) {
            be.setChanged();
        }
        world.sendBlockUpdated(pos, state, state, 3);
    }

    private void connectFence(ItemStack stack, Player user, Level world, BlockPos pos, FenceFastenerEntity fastener) {
        boolean playConnectSound;
        if (fastener == null) {
            fastener = FenceFastenerEntity.create(world, pos);
            playConnectSound = false;
        } else {
            playConnectSound = true;
        }
        this.connect(stack, user, world, CapabilityHandler.getFastenerCapability((Entity)fastener).orElseThrow(IllegalStateException::new), playConnectSound);
    }

    public static boolean isFence(BlockState state) {
        return state.isSolid() && state.is(BlockTags.FENCES);
    }
}

