/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Arrays;
import java.util.Optional;
import me.paulf.fairylights.server.item.FLDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public final class DyeableItem {
    private DyeableItem() {
    }

    public static Component getColorName(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        DyeColor closest = DyeColor.WHITE;
        int closestDist = Integer.MAX_VALUE;
        for (DyeColor dye : DyeColor.values()) {
            int dyeColor = DyeableItem.getColor(dye);
            if (dyeColor == color) {
                closest = dye;
                closestDist = 0;
                break;
            }
            int dr = dyeColor >> 16 & 0xFF;
            int dg = dyeColor >> 8 & 0xFF;
            int db = dyeColor & 0xFF;
            int dist = (dr - r) * (dr - r) + (dg - g) * (dg - g) + (db - b) * (db - b);
            if (dist >= closestDist) continue;
            closest = dye;
            closestDist = dist;
        }
        MutableComponent colorName = Component.translatable((String)("color.fairylights." + closest.getName()));
        return closestDist == 0 ? colorName : Component.translatable((String)"format.fairylights.dyed_colored", (Object[])new Object[]{colorName});
    }

    public static Component getDisplayName(ItemStack stack, Component name) {
        return Component.translatable((String)"format.fairylights.colored", (Object[])new Object[]{DyeableItem.getColorName(DyeableItem.getColor(stack)), name});
    }

    public static int getColor(DyeColor color) {
        if (color == DyeColor.BLACK) {
            return 0x323232;
        }
        if (color == DyeColor.GRAY) {
            return 0x606060;
        }
        int textureColor = color.getTextureDiffuseColor();
        return textureColor;
    }

    public static Optional<DyeColor> getDyeColor(ItemStack stack) {
        int color = DyeableItem.getColor(stack);
        return Arrays.stream(DyeColor.values()).filter(dye -> DyeableItem.getColor(dye) == color).findFirst();
    }

    public static ItemStack setColor(ItemStack stack, DyeColor dye) {
        return DyeableItem.setColor(stack, DyeableItem.getColor(dye));
    }

    public static ItemStack setColor(ItemStack stack, int color) {
        stack.set((DataComponentType)FLDataComponents.COLOR.get(), (Object)color);
        return stack;
    }

    public static CompoundTag setColor(CompoundTag tag, DyeColor dye) {
        return DyeableItem.setColor(tag, DyeableItem.getColor(dye));
    }

    public static CompoundTag setColor(CompoundTag tag, int color) {
        tag.putInt("color", color);
        return tag;
    }

    public static int getColor(ItemStack stack) {
        if (stack.has((DataComponentType)FLDataComponents.COLOR.get())) {
            int color = (Integer)stack.get((DataComponentType)FLDataComponents.COLOR.get());
            return color;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData != null) {
            CompoundTag tag = customData.getUnsafe();
            if (tag.contains("color", 99)) {
                int color = tag.getInt("color");
                return color;
            }
            if (tag.contains("fl_backup_color", 99)) {
                int color = tag.getInt("fl_backup_color");
                return color;
            }
        }
        return 0xFFFFFF;
    }

    public static int getColor(CompoundTag tag) {
        if (tag.contains("color", 99)) {
            return tag.getInt("color");
        }
        if (tag.contains("fl_backup_color", 99)) {
            return tag.getInt("fl_backup_color");
        }
        return 0xFFFFFF;
    }
}

