/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.connection.ConnectionTypes;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public final class HangingLightsConnectionItem
extends ConnectionItem {
    public HangingLightsConnectionItem(Item.Properties properties) {
        super(properties, ConnectionTypes.HANGING_LIGHTS);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag compound = (CompoundTag)stack.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
        if (compound != null) {
            ResourceLocation name = RegistryObjects.getName(FairyLights.STRING_TYPES.get(), HangingLightsConnectionItem.getString(compound));
            tooltip.add((Component)Component.translatable((String)("item." + name.getNamespace() + "." + name.getPath())).withStyle(ChatFormatting.GRAY));
        }
        if (compound != null && compound.contains("pattern", 9)) {
            ListTag tagList = compound.getList("pattern", 10);
            int tagCount = tagList.size();
            if (tagCount > 0) {
                tooltip.add((Component)Component.empty());
            }
            for (int i = 0; i < tagCount; ++i) {
                ItemStack lightStack = ItemStack.parse((HolderLookup.Provider)context.registries(), (Tag)tagList.getCompound(i)).orElse(ItemStack.EMPTY);
                tooltip.add(lightStack.getHoverName());
            }
        }
    }

    public static StringType getString(CompoundTag tag) {
        ResourceKey key;
        if (!tag.contains("string", 8)) {
            return (StringType)StringTypes.BLACK_STRING.get();
        }
        ResourceLocation stringId = ResourceLocation.tryParse((String)tag.getString("string"));
        if (stringId == null) {
            return (StringType)StringTypes.BLACK_STRING.get();
        }
        Registry<StringType> registry = FairyLights.STRING_TYPES.get();
        StringType result = (StringType)registry.get(key = ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)FairyLights.STRING_TYPE), (ResourceLocation)stringId));
        return result != null ? result : (StringType)StringTypes.BLACK_STRING.get();
    }

    public static void setString(CompoundTag tag, StringType string) {
        tag.putString("string", RegistryObjects.getName(FairyLights.STRING_TYPES.get(), string).toString());
    }
}

