/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.item.DyeableItem;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LightItem
extends BlockItem {
    private final LightBlock light;

    public LightItem(LightBlock light, Item.Properties properties) {
        super((Block)light, properties);
        this.light = light;
    }

    public LightBlock getBlock() {
        return this.light;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = new CompoundTag();
        if (!tag.isEmpty()) {
            if (tag.getBoolean("twinkle")) {
                tooltip.add((Component)Component.translatable((String)"item.fairyLights.twinkle").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
            if (tag.contains("colors", 9)) {
                ListTag colors = tag.getList("colors", 3);
                for (int i = 0; i < colors.size(); ++i) {
                    tooltip.add((Component)DyeableItem.getColorName(colors.getInt(i)).copy().withStyle(ChatFormatting.GRAY));
                }
            }
        }
    }
}

