/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.Optional;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.LightItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public interface LightVariant<T extends LightBehavior> {
    public boolean parallelsCord();

    public float getSpacing();

    public AABB getBounds();

    public double getFloorOffset();

    public T createBehavior(ItemStack var1);

    public boolean isOrientable();

    public static Optional<LightVariant<?>> get(ItemStack stack) {
        LightItem lightItem;
        LightBlock block;
        if (stack.isEmpty()) {
            return Optional.empty();
        }
        Item item = stack.getItem();
        if (item instanceof LightItem && (block = (lightItem = (LightItem)item).getBlock()) instanceof LightBlock) {
            LightBlock lightBlock = block;
            return Optional.of(lightBlock.getVariant());
        }
        return Optional.empty();
    }
}

