/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import me.paulf.fairylights.server.connection.ConnectionTypes;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class PennantBuntingConnectionItem
extends ConnectionItem {
    public PennantBuntingConnectionItem(Item.Properties properties) {
        super(properties, ConnectionTypes.PENNANT_BUNTING);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        StyledString s;
        CompoundTag tag = (CompoundTag)stack.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
        if (tag != null && tag.contains("pattern", 9)) {
            ListTag tagList = tag.getList("pattern", 10);
            int tagCount = tagList.size();
            if (tagCount > 0) {
                tooltip.add((Component)Component.empty());
            }
            for (int i = 0; i < tagCount; ++i) {
                ItemStack item = ItemStack.parse((HolderLookup.Provider)context.registries(), (Tag)tagList.getCompound(i)).orElse(ItemStack.EMPTY);
                tooltip.add(item.getHoverName());
            }
        } else if (tag != null && tag.contains("text", 10) && (s = StyledString.deserialize(tag.getCompound("text"))).length() > 0) {
            tooltip.add((Component)Component.translatable((String)"format.fairylights.text", (Object[])new Object[]{s.toTextComponent()}).withStyle(ChatFormatting.GRAY));
        }
    }
}

