/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item.crafting;

import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CopyColorRecipe
extends CustomRecipe {
    public CopyColorRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level world) {
        int count = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || stack.is(FLCraftingRecipes.DYEABLE) && count++ < 2) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack original = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (!stack.is(FLCraftingRecipes.DYEABLE)) break;
            if (original.isEmpty()) {
                original = stack;
                continue;
            }
            ItemStack copy = stack.copy();
            copy.setCount(1);
            DyeableItem.setColor(copy, DyeableItem.getColor(original));
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        ItemStack original = ItemStack.EMPTY;
        NonNullList remaining = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.hasCraftingRemainingItem()) {
                remaining.set(i, (Object)stack.getCraftingRemainingItem());
                continue;
            }
            if (!original.isEmpty() || stack.isEmpty() || !stack.is(FLCraftingRecipes.DYEABLE)) continue;
            ItemStack rem = stack.copy();
            rem.setCount(1);
            remaining.set(i, (Object)rem);
            original = stack;
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)FLCraftingRecipes.COPY_COLOR.get();
    }
}

