/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item.crafting;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLDataComponents;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.crafting.CopyColorRecipe;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.Blender;
import me.paulf.fairylights.util.OreDictUtils;
import me.paulf.fairylights.util.Utils;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.GenericRecipeBuilder;
import me.paulf.fairylights.util.crafting.ingredient.BasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.BasicRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.InertBasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.LazyTagIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FLCraftingRecipes {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DeferredRegister<RecipeSerializer<?>> REG;
    private static final ResourceLocation PLACEHOLDER_ID;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> HANGING_LIGHTS;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> HANGING_LIGHTS_AUGMENTATION;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> TINSEL_GARLAND;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> PENNANT_BUNTING;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> PENNANT_BUNTING_AUGMENTATION;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> TRIANGLE_PENNANT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SPEARHEAD_PENNANT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SWALLOWTAIL_PENNANT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SQUARE_PENNANT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> FAIRY_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> PAPER_LANTERN;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> ORB_LANTERN;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> FLOWER_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> CANDLE_LANTERN_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> OIL_LANTERN_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> JACK_O_LANTERN;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SKULL_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> GHOST_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SPIDER_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> WITCH_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> SNOWFLAKE_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> HEART_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> MOON_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> STAR_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> ICICLE_LIGHTS;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> METEOR_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> LIGHT_TWINKLE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> COLOR_CHANGING_LIGHT;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<GenericRecipe>> EDIT_COLOR;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<CustomRecipe>> COPY_COLOR;
    public static final TagKey<Item> LIGHTS;
    public static final TagKey<Item> TWINKLING_LIGHTS;
    public static final TagKey<Item> PENNANTS;
    public static final TagKey<Item> DYEABLE;
    public static final TagKey<Item> DYEABLE_LIGHTS;
    public static final RegularIngredient DYE_SUBTYPE_INGREDIENT;

    private FLCraftingRecipes() {
    }

    public static GenericRecipe createHangingLightsWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createHangingLights(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createHangingLightsAugmentationWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createHangingLightsAugmentation(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createTinselGarlandWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createTinselGarland(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createPennantBuntingWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createPennantBunting(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createPennantBuntingAugmentationWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createPennantBuntingAugmentation(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createTrianglePennantWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createTrianglePennant(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSpearheadPennantWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSpearheadPennant(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSwallowtailPennantWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSwallowtailPennant(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSquarePennantWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSquarePennant(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createFairyLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createFairyLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createPaperLanternWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createPaperLantern(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createOrbLanternWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createOrbLantern(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createFlowerLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createFlowerLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createCandleLanternLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createCandleLanternLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createOilLanternLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createOilLanternLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createJackOLanternWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createJackOLantern(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSkullLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSkullLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createGhostLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createGhostLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSpiderLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSpiderLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createWitchLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createWitchLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createSnowflakeLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createSnowflakeLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createHeartLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createHeartLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createMoonLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createMoonLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createStarLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createStarLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createIcicleLightsWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createIcicleLights(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createMeteorLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createMeteorLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createLightTwinkleWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createLightTwinkle(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createColorChangingLightWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createColorChangingLight(PLACEHOLDER_ID, category);
    }

    public static GenericRecipe createDyeColorWrapper(CraftingBookCategory category) {
        return FLCraftingRecipes.createDyeColor(PLACEHOLDER_ID, category);
    }

    public static CustomRecipe createCopyColorWrapper(CraftingBookCategory category) {
        return new CopyColorRecipe(PLACEHOLDER_ID, category);
    }

    private static GenericRecipe createDyeColor(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)EDIT_COLOR).withShape("I").withIngredient('I', DYEABLE).withOutput('I').withAuxiliaryIngredient(new BasicAuxiliaryIngredient<Blender>(Ingredient.of((Stream)OreDictUtils.getAllDyes().stream()), true, 8){

            @Override
            public Blender accumulator() {
                return new Blender();
            }

            @Override
            public void consume(Blender data, ItemStack ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(Blender data, CompoundTag nbt) {
                DyeableItem.setColor(nbt, data.blend());
                return false;
            }
        }).build();
    }

    private static GenericRecipe createLightTwinkle(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)LIGHT_TWINKLE).withShape("L").withIngredient('L', TWINKLING_LIGHTS).withOutput('L').withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE), true, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return FLCraftingRecipes.useInputsForTagBool(output, true) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(CompoundTag nbt) {
            }

            @Override
            public void absent(CompoundTag nbt) {
            }

            @Override
            public void addTooltip(List<Component> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.twinkling_lights.glowstone"));
            }
        }).build();
    }

    private static GenericRecipe createColorChangingLight(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)COLOR_CHANGING_LIGHT).build();
    }

    private static GenericRecipe createHangingLights(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        ItemStack output = new ItemStack((ItemLike)FLItems.HANGING_LIGHTS.get());
        CompoundTag logic = new CompoundTag();
        HangingLightsConnectionItem.setString(logic, (StringType)StringTypes.BLACK_STRING.get());
        output.set((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)logic);
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)HANGING_LIGHTS, output).withShape("I-I").withIngredient('I', Items.IRON_INGOT).withIngredient('-', Items.STRING).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((TagKey<Item>)Tags.Items.DYES_WHITE), false, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                CompoundTag logic = (CompoundTag)output.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
                if (logic != null && HangingLightsConnectionItem.getString(logic) == StringTypes.WHITE_STRING.get()) {
                    return super.getInput(output);
                }
                return ImmutableList.of();
            }

            @Override
            public void present(CompoundTag nbt) {
                HangingLightsConnectionItem.setString(nbt, (StringType)StringTypes.WHITE_STRING.get());
            }

            @Override
            public void absent(CompoundTag nbt) {
            }

            @Override
            public void addTooltip(List<Component> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.string"));
            }
        }).build();
    }

    private static boolean useInputsForTagBool(ItemStack output, boolean value) {
        return (Boolean)output.getOrDefault((DataComponentType)FLDataComponents.TWINKLE.get(), (Object)false) == value;
    }

    private static GenericRecipe createHangingLightsAugmentation(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)HANGING_LIGHTS_AUGMENTATION, (Item)FLItems.HANGING_LIGHTS.get()).withShape("F").withIngredient('F', new BasicRegularIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)FLItems.HANGING_LIGHTS.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.getItems()).map(ItemStack::copy).flatMap(stack -> FLCraftingRecipes.makeHangingLightsExamples(stack).stream()).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return ImmutableList.of((Object)ImmutableList.of((Object)output.copy()));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundTag nbt) {
            }
        }).withAuxiliaryIngredient(new LightIngredient(true){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return ImmutableList.of();
            }
        }).build();
    }

    private static ImmutableList<ItemStack> makeHangingLightsExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.MAGENTA, DyeColor.CYAN, DyeColor.WHITE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PINK, DyeColor.CYAN, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PURPLE, DyeColor.LIGHT_GRAY, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.YELLOW, DyeColor.CYAN, DyeColor.PURPLE));
    }

    public static ItemStack makeHangingLights(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.copy();
        CompoundTag logic = new CompoundTag();
        ListTag lights = new ListTag();
        RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        for (DyeColor color : colors) {
            ItemStack coloredLight = DyeableItem.setColor(new ItemStack((ItemLike)FLItems.FAIRY_LIGHT.get()), color);
            lights.add((Object)coloredLight.save((HolderLookup.Provider)registryAccess));
        }
        logic.put("pattern", (Tag)lights);
        HangingLightsConnectionItem.setString(logic, (StringType)StringTypes.BLACK_STRING.get());
        stack.set((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)logic);
        return stack;
    }

    private static GenericRecipe createTinselGarland(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)TINSEL_GARLAND, (Item)FLItems.TINSEL.get()).withShape(" P ", "I-I", " D ").withIngredient('P', Items.PAPER).withIngredient('I', Items.IRON_INGOT).withIngredient('-', Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createPennantBunting(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        ItemStack output = new ItemStack((ItemLike)FLItems.PENNANT_BUNTING.get());
        output.set((DataComponentType)FLDataComponents.STYLED_STRING.get(), (Object)StyledString.serialize(new StyledString()));
        output.set((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)new CompoundTag());
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)PENNANT_BUNTING, output).withShape("I-I").withIngredient('I', Items.IRON_INGOT).withIngredient('-', Items.STRING).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static GenericRecipe createPennantBuntingAugmentation(ResourceLocation name, CraftingBookCategory craftingBookCategory) {
        ItemStack output = new ItemStack((ItemLike)FLItems.PENNANT_BUNTING.get());
        output.set((DataComponentType)FLDataComponents.STYLED_STRING.get(), (Object)StyledString.serialize(new StyledString()));
        output.set((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)new CompoundTag());
        return new GenericRecipeBuilder(name, (Supplier<? extends RecipeSerializer<GenericRecipe>>)PENNANT_BUNTING_AUGMENTATION, output).withShape("B").withIngredient('B', new BasicRegularIngredient(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)FLItems.PENNANT_BUNTING.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.getItems()).map(ItemStack::copy).flatMap(stack -> FLCraftingRecipes.makePennantExamples(stack).stream()).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return ImmutableList.of((Object)ImmutableList.of((Object)((ItemStack)FLCraftingRecipes.makePennantExamples(output).get(0))));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundTag nbt) {
            }
        }).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static ImmutableList<ItemStack> makePennantExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makePennant(stack, DyeColor.BLUE, DyeColor.YELLOW, DyeColor.RED), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.PINK, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.ORANGE, DyeColor.WHITE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.LIME, DyeColor.YELLOW));
    }

    public static ItemStack makePennant(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.copy();
        CompoundTag logic = new CompoundTag();
        ListTag pennants = new ListTag();
        RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        for (DyeColor color : colors) {
            ItemStack pennant = new ItemStack((ItemLike)FLItems.TRIANGLE_PENNANT.get());
            DyeableItem.setColor(pennant, color);
            pennants.add((Object)pennant.save((HolderLookup.Provider)registryAccess));
        }
        logic.put("pattern", (Tag)pennants);
        stack.set((DataComponentType)FLDataComponents.STYLED_STRING.get(), (Object)StyledString.serialize(new StyledString()));
        stack.set((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get(), (Object)logic);
        return stack;
    }

    private static GenericRecipe createPennant(ResourceLocation name, Supplier<RecipeSerializer<GenericRecipe>> serializer, Item item, String pattern) {
        return new GenericRecipeBuilder(name, serializer, item).withShape("- -", "PDP", pattern).withIngredient('P', Items.PAPER).withIngredient('-', Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createTrianglePennant(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createPennant(name, TRIANGLE_PENNANT, (Item)FLItems.TRIANGLE_PENNANT.get(), " P ");
    }

    private static GenericRecipe createSpearheadPennant(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createPennant(name, SPEARHEAD_PENNANT, (Item)FLItems.SPEARHEAD_PENNANT.get(), " PP");
    }

    private static GenericRecipe createSwallowtailPennant(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createPennant(name, SWALLOWTAIL_PENNANT, (Item)FLItems.SWALLOWTAIL_PENNANT.get(), "P P");
    }

    private static GenericRecipe createSquarePennant(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createPennant(name, SQUARE_PENNANT, (Item)FLItems.SQUARE_PENNANT.get(), "PPP");
    }

    private static GenericRecipe createFairyLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, FAIRY_LIGHT, FLItems.FAIRY_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', Items.GLASS_PANE));
    }

    private static GenericRecipe createPaperLantern(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, PAPER_LANTERN, FLItems.PAPER_LANTERN, b -> b.withShape(" I ", "PDP", "PPP").withIngredient('P', Items.PAPER));
    }

    private static GenericRecipe createOrbLantern(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, ORB_LANTERN, FLItems.ORB_LANTERN, b -> b.withShape(" I ", "SDS", " W ").withIngredient('S', Items.STRING).withIngredient('W', Items.WHITE_WOOL));
    }

    private static GenericRecipe createFlowerLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, FLOWER_LIGHT, FLItems.FLOWER_LIGHT, b -> b.withShape(" I ", "RDB", " Y ").withIngredient('R', Items.POPPY).withIngredient('Y', Items.DANDELION).withIngredient('B', Items.BLUE_ORCHID));
    }

    private static GenericRecipe createCandleLanternLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, CANDLE_LANTERN_LIGHT, FLItems.CANDLE_LANTERN_LIGHT, b -> b.withShape(" I ", "GDG", "IGI").withIngredient('G', Items.GOLD_NUGGET));
    }

    private static GenericRecipe createOilLanternLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, OIL_LANTERN_LIGHT, FLItems.OIL_LANTERN_LIGHT, b -> b.withShape(" I ", "SDS", "IGI").withIngredient('S', Items.STICK).withIngredient('G', Items.GLASS_PANE));
    }

    private static GenericRecipe createJackOLantern(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, JACK_O_LANTERN, FLItems.JACK_O_LANTERN, b -> b.withShape(" I ", "SDS", "GPG").withIngredient('S', (TagKey<Item>)ItemTags.WOODEN_SLABS).withIngredient('G', Items.TORCH).withIngredient('P', Items.JACK_O_LANTERN));
    }

    private static GenericRecipe createSkullLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, SKULL_LIGHT, FLItems.SKULL_LIGHT, b -> b.withShape(" I ", "IDI", " B ").withIngredient('B', Items.BONE));
    }

    private static GenericRecipe createGhostLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, GHOST_LIGHT, FLItems.GHOST_LIGHT, b -> b.withShape(" I ", "PDP", "IGI").withIngredient('P', Items.PAPER).withIngredient('G', Items.WHITE_STAINED_GLASS_PANE));
    }

    private static GenericRecipe createSpiderLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, SPIDER_LIGHT, FLItems.SPIDER_LIGHT, b -> b.withShape(" I ", "WDW", "SES").withIngredient('W', Items.COBWEB).withIngredient('S', Items.STRING).withIngredient('E', Items.SPIDER_EYE));
    }

    private static GenericRecipe createWitchLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, WITCH_LIGHT, FLItems.WITCH_LIGHT, b -> b.withShape(" I ", "BDW", " S ").withIngredient('B', Items.GLASS_BOTTLE).withIngredient('W', Items.WHEAT).withIngredient('S', Items.STICK));
    }

    private static GenericRecipe createSnowflakeLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, SNOWFLAKE_LIGHT, FLItems.SNOWFLAKE_LIGHT, b -> b.withShape(" I ", "SDS", " G ").withIngredient('S', Items.SNOWBALL).withIngredient('G', Items.WHITE_STAINED_GLASS_PANE));
    }

    private static GenericRecipe createHeartLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, HEART_LIGHT, FLItems.HEART_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', Items.RED_STAINED_GLASS_PANE));
    }

    private static GenericRecipe createMoonLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, MOON_LIGHT, FLItems.MOON_LIGHT, b -> b.withShape(" I ", "GDG", " C ").withIngredient('G', Items.WHITE_STAINED_GLASS_PANE).withIngredient('C', Items.CLOCK));
    }

    private static GenericRecipe createStarLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, STAR_LIGHT, FLItems.STAR_LIGHT, b -> b.withShape(" I ", "PDP", " G ").withIngredient('P', Items.WHITE_STAINED_GLASS_PANE).withIngredient('G', Items.GOLD_NUGGET));
    }

    private static GenericRecipe createIcicleLights(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, ICICLE_LIGHTS, FLItems.ICICLE_LIGHTS, b -> b.withShape(" I ", "GDG", " B ").withIngredient('G', Items.GLASS_PANE).withIngredient('B', Items.WATER_BUCKET));
    }

    private static GenericRecipe createMeteorLight(ResourceLocation name, CraftingBookCategory category) {
        return FLCraftingRecipes.createLight(name, METEOR_LIGHT, FLItems.METEOR_LIGHT, b -> b.withShape(" I ", "GDG", "IPI").withIngredient('G', Items.GLOWSTONE_DUST).withIngredient('P', Items.PAPER));
    }

    private static GenericRecipe createLight(ResourceLocation name, Supplier<? extends RecipeSerializer<GenericRecipe>> serializer, Supplier<? extends Item> variant, UnaryOperator<GenericRecipeBuilder> recipe) {
        return ((GenericRecipeBuilder)recipe.apply(new GenericRecipeBuilder(name, serializer))).withIngredient('I', Items.IRON_INGOT).withIngredient('D', DYE_SUBTYPE_INGREDIENT).withOutput(variant.get(), 4).build();
    }

    static {
        LogUtils.getLogger().info("FLCraftingRecipes class loaded! Registering serializers...");
        REG = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"fairylights");
        PLACEHOLDER_ID = ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"placeholder");
        HANGING_LIGHTS = REG.register("crafting_special_hanging_lights", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHangingLightsWrapper));
        HANGING_LIGHTS_AUGMENTATION = REG.register("crafting_special_hanging_lights_augmentation", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHangingLightsAugmentationWrapper));
        TINSEL_GARLAND = REG.register("crafting_special_tinsel_garland", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createTinselGarlandWrapper));
        PENNANT_BUNTING = REG.register("crafting_special_pennant_bunting", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPennantBuntingWrapper));
        PENNANT_BUNTING_AUGMENTATION = REG.register("crafting_special_pennant_bunting_augmentation", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPennantBuntingAugmentationWrapper));
        TRIANGLE_PENNANT = REG.register("crafting_special_triangle_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createTrianglePennantWrapper));
        SPEARHEAD_PENNANT = REG.register("crafting_special_spearhead_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSpearheadPennantWrapper));
        SWALLOWTAIL_PENNANT = REG.register("crafting_special_swallowtail_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSwallowtailPennantWrapper));
        SQUARE_PENNANT = REG.register("crafting_special_square_pennant", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSquarePennantWrapper));
        FAIRY_LIGHT = REG.register("crafting_special_fairy_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createFairyLightWrapper));
        PAPER_LANTERN = REG.register("crafting_special_paper_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createPaperLanternWrapper));
        ORB_LANTERN = REG.register("crafting_special_orb_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createOrbLanternWrapper));
        FLOWER_LIGHT = REG.register("crafting_special_flower_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createFlowerLightWrapper));
        CANDLE_LANTERN_LIGHT = REG.register("crafting_special_candle_lantern_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createCandleLanternLightWrapper));
        OIL_LANTERN_LIGHT = REG.register("crafting_special_oil_lantern_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createOilLanternLightWrapper));
        JACK_O_LANTERN = REG.register("crafting_special_jack_o_lantern", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createJackOLanternWrapper));
        SKULL_LIGHT = REG.register("crafting_special_skull_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSkullLightWrapper));
        GHOST_LIGHT = REG.register("crafting_special_ghost_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createGhostLightWrapper));
        SPIDER_LIGHT = REG.register("crafting_special_spider_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSpiderLightWrapper));
        WITCH_LIGHT = REG.register("crafting_special_witch_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createWitchLightWrapper));
        SNOWFLAKE_LIGHT = REG.register("crafting_special_snowflake_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createSnowflakeLightWrapper));
        HEART_LIGHT = REG.register("crafting_special_heart_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createHeartLightWrapper));
        MOON_LIGHT = REG.register("crafting_special_moon_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createMoonLightWrapper));
        STAR_LIGHT = REG.register("crafting_special_star_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createStarLightWrapper));
        ICICLE_LIGHTS = REG.register("crafting_special_icicle_lights", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createIcicleLightsWrapper));
        METEOR_LIGHT = REG.register("crafting_special_meteor_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createMeteorLightWrapper));
        LIGHT_TWINKLE = REG.register("crafting_special_light_twinkle", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createLightTwinkleWrapper));
        COLOR_CHANGING_LIGHT = REG.register("crafting_special_color_changing_light", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createColorChangingLightWrapper));
        EDIT_COLOR = REG.register("crafting_special_edit_color", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createDyeColorWrapper));
        COPY_COLOR = REG.register("crafting_special_copy_color", () -> new SimpleCraftingRecipeSerializer(FLCraftingRecipes::createCopyColorWrapper));
        LIGHTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"lights"));
        TWINKLING_LIGHTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"twinkling_lights"));
        PENNANTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"pennants"));
        DYEABLE = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"dyeable"));
        DYEABLE_LIGHTS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"dyeable_lights"));
        DYE_SUBTYPE_INGREDIENT = new BasicRegularIngredient(Ingredient.of((Stream)OreDictUtils.getAllDyes().stream())){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return DyeableItem.getDyeColor(output).map(dye -> ImmutableList.of(OreDictUtils.getDyes(dye))).orElseGet(() -> {
                    LOGGER.warn("DYE_SUBTYPE_INGREDIENT: Could not find dye color for output: " + String.valueOf(output) + " with color: " + DyeableItem.getColor(output));
                    return ImmutableList.of();
                });
            }

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return OreDictUtils.getAllDyes();
            }

            @Override
            public GenericRecipe.MatchResultRegular matches(ItemStack input) {
                return new GenericRecipe.MatchResultRegular(this, input, OreDictUtils.isDye(input), (List<GenericRecipe.MatchResultRegular>)ImmutableList.of());
            }

            @Override
            public boolean dictatesOutputType() {
                return true;
            }

            @Override
            public void matched(ItemStack ingredient, CompoundTag nbt) {
                nbt.putInt("color", DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }
        };
    }

    private static class LightIngredient
    extends BasicAuxiliaryIngredient<ListTag> {
        private LightIngredient(boolean isRequired) {
            super(Ingredient.of(FLItems.lights().map(ItemStack::new)), isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            CompoundTag logic = (CompoundTag)output.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
            if (logic != null) {
                ListTag pattern = logic.getList("pattern", 10);
                if (!pattern.isEmpty()) {
                    ImmutableList.Builder lights = ImmutableList.builder();
                    RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
                    for (int i = 0; i < pattern.size(); ++i) {
                        ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)pattern.getCompound(i)).orElse(ItemStack.EMPTY);
                        if (stack.isEmpty()) {
                            LOGGER.error("LightIngredient.getInput: Failed to parse itemstack from pattern at index " + i + ": " + String.valueOf(pattern.getCompound(i)));
                        }
                        lights.add((Object)ImmutableList.of((Object)stack));
                    }
                    return lights.build();
                }
            } else {
                LOGGER.warn("LightIngredient.getInput: No CONNECTION_LOGIC for output: " + String.valueOf(output));
            }
            return ImmutableList.of();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListTag accumulator() {
            return new ListTag();
        }

        @Override
        public void consume(ListTag patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.save((HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)));
        }

        @Override
        public boolean finish(ListTag pattern, CompoundTag nbt) {
            if (pattern.size() > 0) {
                nbt.put("pattern", (Tag)pattern);
            }
            return false;
        }
    }

    private static class PennantIngredient
    extends BasicAuxiliaryIngredient<ListTag> {
        private PennantIngredient() {
            super(Ingredient.of(Stream.of((Item)FLItems.TRIANGLE_PENNANT.get(), (Item)FLItems.SPEARHEAD_PENNANT.get(), (Item)FLItems.SWALLOWTAIL_PENNANT.get(), (Item)FLItems.SQUARE_PENNANT.get()).map(ItemStack::new)), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            ListTag pattern;
            CompoundTag logic = (CompoundTag)output.get((DataComponentType)FLDataComponents.CONNECTION_LOGIC.get());
            if (logic != null && !(pattern = logic.getList("pattern", 10)).isEmpty()) {
                ImmutableList.Builder pennants = ImmutableList.builder();
                RegistryAccess.Frozen registryAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
                for (int i = 0; i < pattern.size(); ++i) {
                    ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryAccess, (Tag)pattern.getCompound(i)).orElse(ItemStack.EMPTY);
                    if (stack.isEmpty()) {
                        LOGGER.error("PennantIngredient.getInput: Failed to parse itemstack from pattern at index " + i + ": " + String.valueOf(pattern.getCompound(i)));
                    }
                    pennants.add((Object)ImmutableList.of((Object)stack));
                }
                return pennants.build();
            }
            return ImmutableList.of();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListTag accumulator() {
            return new ListTag();
        }

        @Override
        public void consume(ListTag patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.save((HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY)));
        }

        @Override
        public boolean finish(ListTag pattern, CompoundTag nbt) {
            if (pattern.size() > 0) {
                nbt.put("pattern", (Tag)pattern);
            }
            return false;
        }
    }
}

