/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;

public final class Jingle {
    public static final Codec<Jingle> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("title").forGetter(j -> j.title), (App)Codec.STRING.fieldOf("artist").forGetter(j -> j.artist), (App)PlayTick.CODEC.listOf().fieldOf("ticks").xmap(l -> ObjectLists.unmodifiable((ObjectList)new ObjectArrayList((Collection)l)), l -> l).forGetter(j -> j.ticks)).apply((Applicative)builder, Jingle::new));
    private final String title;
    private final String artist;
    private final ObjectList<PlayTick> ticks;
    private int range = -1;
    private int min;

    private Jingle(String title, String artist, ObjectList<PlayTick> ticks) {
        this.title = title;
        this.artist = artist;
        this.ticks = ticks;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public int getLength() {
        int length = 0;
        for (PlayTick playTick : this.ticks) {
            length += playTick.getDuration();
        }
        return length;
    }

    public List<PlayTick> getPlayTicks() {
        return this.ticks;
    }

    public int getLowestNote() {
        this.calculateRange();
        return this.min;
    }

    public int getRange() {
        this.calculateRange();
        return this.range;
    }

    private void calculateRange() {
        if (this.range == -1) {
            if (this.ticks.isEmpty()) {
                this.min = 0;
                this.range = 1;
            } else {
                int minNote = 24;
                int maxNote = 0;
                for (PlayTick tick : this.ticks) {
                    for (int note : tick.notes) {
                        maxNote = Math.max(maxNote, note);
                        minNote = Math.min(minNote, note);
                    }
                }
                this.min = minNote;
                this.range = maxNote - minNote + 1;
            }
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.title);
        buf.writeUtf(this.artist);
        buf.writeVarInt(this.ticks.size());
        for (PlayTick tick : this.ticks) {
            int bits = 0;
            for (int n : tick.notes) {
                bits |= 1 << n;
            }
            buf.writeInt(tick.duration << 25 | bits & 0x1FFFFFF);
        }
    }

    public static Jingle read(FriendlyByteBuf buf) {
        String title = buf.readUtf();
        String artist = buf.readUtf();
        int len = buf.readVarInt();
        ObjectArrayList ticks = new ObjectArrayList(len);
        int rem = len;
        while (rem-- > 0) {
            int packed = buf.readInt();
            int duration = packed >> 25 & 0x7F;
            int bits = packed & 0x1FFFFFF;
            int[] notes = new int[Integer.bitCount(bits)];
            int i = 0;
            for (int n = 0; n < 25; ++n) {
                if ((bits & 1 << n) == 0) continue;
                notes[i++] = n;
            }
            ticks.add((Object)new PlayTick(duration, notes));
        }
        return new Jingle(title, artist, (ObjectList<PlayTick>)ObjectLists.unmodifiable((ObjectList)ticks));
    }

    static final class PlayTick {
        public static final Codec<PlayTick> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("duration").forGetter(t -> t.duration), (App)Codec.INT_STREAM.fieldOf("notes").xmap(IntStream::toArray, Arrays::stream).forGetter(t -> t.notes)).apply((Applicative)builder, PlayTick::new));
        final int duration;
        final int[] notes;

        PlayTick(int duration, int[] notes) {
            this.duration = duration;
            this.notes = notes;
        }

        public int getDuration() {
            return this.duration;
        }

        public int[] getNotes() {
            return this.notes;
        }
    }
}

