/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.jingle.Jingle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class JingleLibrary {
    public static final String CHRISTMAS = "christmas";
    public static final String HALLOWEEN = "halloween";
    public static final String RANDOM = "";
    private static final int MAX_RANGE = 25;
    private final Object2ObjectMap<ResourceLocation, Jingle> jingles;
    private final Int2ObjectMap<RangeSet> ranges;

    private JingleLibrary() {
        this.jingles = Object2ObjectMaps.emptyMap();
        this.ranges = Int2ObjectMaps.emptyMap();
    }

    private JingleLibrary(Builder builder) {
        this.jingles = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap(builder.jingles));
        Int2ObjectOpenHashMap ranges = new Int2ObjectOpenHashMap();
        Int2ObjectMaps.fastForEach(builder.ranges, arg_0 -> JingleLibrary.lambda$new$0((Int2ObjectMap)ranges, arg_0));
        this.ranges = Int2ObjectMaps.unmodifiable((Int2ObjectMap)ranges);
    }

    @Nullable
    public Jingle get(ResourceLocation name) {
        return (Jingle)this.jingles.get((Object)name);
    }

    @Nullable
    public Jingle getRandom(RandomSource rng, int range) {
        RangeSet jingles = (RangeSet)this.ranges.get(Math.min(range, 25));
        return jingles == null ? null : jingles.get(rng);
    }

    public static JingleLibrary empty() {
        return new JingleLibrary();
    }

    private static /* synthetic */ void lambda$new$0(Int2ObjectMap ranges, Int2ObjectMap.Entry e) {
        ranges.put(e.getIntKey(), (Object)((RangeSet.Builder)e.getValue()).build());
    }

    public static class Builder {
        final Object2ObjectMap<ResourceLocation, Jingle> jingles = new Object2ObjectOpenHashMap();
        final Int2ObjectMap<RangeSet.Builder> ranges = new Int2ObjectOpenHashMap();

        public Builder add(ResourceLocation id, Jingle jingle) {
            this.jingles.put((Object)id, (Object)jingle);
            for (int range = jingle.getRange(); range <= 25; ++range) {
                ((RangeSet.Builder)this.ranges.computeIfAbsent(range, r -> new RangeSet.Builder())).add(jingle);
            }
            return this;
        }

        public JingleLibrary build() {
            return new JingleLibrary(this);
        }
    }

    private static class RangeSet {
        final ObjectList<Jingle> jingles;
        final int total;

        RangeSet(Builder builder) {
            this.jingles = ObjectLists.unmodifiable(builder.jingles);
            this.total = builder.total;
        }

        @Nullable
        public Jingle get(RandomSource rng) {
            if (this.jingles.isEmpty()) {
                return null;
            }
            float choice = rng.nextFloat() * (float)this.total;
            for (Jingle jingle : this.jingles) {
                if (!((choice -= (float)jingle.getRange()) <= 0.0f)) continue;
                return jingle;
            }
            return null;
        }

        static class Builder {
            final ObjectList<Jingle> jingles = new ObjectArrayList();
            int total;

            Builder() {
            }

            void add(Jingle jingle) {
                this.jingles.add((Object)jingle);
                this.total += jingle.getRange();
            }

            RangeSet build() {
                return new RangeSet(this);
            }
        }
    }
}

