/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleLibrary;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JingleManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    public static final JingleManager INSTANCE = new JingleManager();
    private Object2ObjectMap<String, JingleLibrary> libraries = Object2ObjectMaps.emptyMap();

    public JingleManager() {
        super(GSON, "jingles");
    }

    public JingleLibrary get(String library) {
        return (JingleLibrary)this.libraries.getOrDefault((Object)library, (Object)JingleLibrary.empty());
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager manager, ProfilerFiller profiler) {
        Object2ObjectOpenHashMap builders = new Object2ObjectOpenHashMap();
        elements.forEach((arg_0, arg_1) -> JingleManager.lambda$apply$3((Object2ObjectMap)builders, arg_0, arg_1));
        Object2ObjectOpenHashMap libraries = new Object2ObjectOpenHashMap(builders.size());
        Object2ObjectMaps.fastForEach((Object2ObjectMap)builders, arg_0 -> JingleManager.lambda$apply$4((Object2ObjectMap)libraries, arg_0));
        this.libraries = libraries;
    }

    private static /* synthetic */ void lambda$apply$4(Object2ObjectMap libraries, Object2ObjectMap.Entry e) {
        libraries.put((Object)((String)e.getKey()), (Object)((JingleLibrary.Builder)e.getValue()).build());
    }

    private static /* synthetic */ void lambda$apply$3(Object2ObjectMap builders, ResourceLocation file, JsonElement json) {
        String path = file.getPath();
        int sl = path.indexOf(47);
        String library = path.substring(0, Math.max(0, sl));
        ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)file.getNamespace(), (String)path.substring(sl + 1));
        Jingle.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(error -> LOGGER.warn("Parsing error loading jingle {}: {}", (Object)file, error)).ifPresent(jingle -> ((JingleLibrary.Builder)builders.computeIfAbsent((Object)library, l -> new JingleLibrary.Builder())).add(name, (Jingle)jingle));
    }
}

