/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.server.net.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public abstract class ConnectionMessage
implements Message {
    public BlockPos pos;
    public FastenerAccessor accessor;
    public UUID uuid;

    public ConnectionMessage() {
    }

    public ConnectionMessage(Connection connection) {
        Fastener<?> fastener = connection.getFastener();
        this.pos = fastener.getPos();
        this.accessor = fastener.createAccessor();
        this.uuid = connection.getUUID();
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeNbt((Tag)FastenerType.serialize(this.accessor));
        buf.writeUUID(this.uuid);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.accessor = FastenerType.deserialize(Objects.requireNonNull(buf.readNbt(), "tag"));
        this.uuid = buf.readUUID();
    }

    public static <C extends Connection> Optional<C> getConnection(ConnectionMessage message, Predicate<? super Connection> typePredicate, Level world) {
        return message.accessor.get(world, false).map(Optional::of).orElse(Optional.empty()).flatMap(f -> f.get(message.uuid).filter(typePredicate));
    }
}

