/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.paulf.fairylights.server.net.ClientMessageContext;
import me.paulf.fairylights.server.net.Message;
import me.paulf.fairylights.server.net.MessageContext;
import me.paulf.fairylights.server.net.ServerMessageContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public final class NetBuilder {
    private final ResourceLocation name;
    private String version;
    private PayloadRegistrar registrar;
    private int id;
    private final Map<Class<? extends Message>, BiConsumer<? extends Message, ? extends MessageContext>> clientboundHandlers = new HashMap<Class<? extends Message>, BiConsumer<? extends Message, ? extends MessageContext>>();
    private final Map<Class<? extends Message>, BiConsumer<? extends Message, ? extends MessageContext>> serverboundHandlers = new HashMap<Class<? extends Message>, BiConsumer<? extends Message, ? extends MessageContext>>();

    public NetBuilder(ResourceLocation name) {
        this.name = name;
    }

    public NetBuilder version(int version) {
        return this.version(String.valueOf(version));
    }

    public NetBuilder version(String version) {
        if (this.version == null) {
            this.version = Objects.requireNonNull(version);
            return this;
        }
        throw new IllegalArgumentException("version already assigned");
    }

    public NetBuilder optionalServer() {
        return this;
    }

    public NetBuilder requiredServer() {
        return this;
    }

    public NetBuilder optionalClient() {
        return this;
    }

    public NetBuilder requiredClient() {
        return this;
    }

    public PayloadRegistrar getRegistrar() {
        return this.registrar;
    }

    public void setRegistrar(PayloadRegistrar registrar) {
        this.registrar = registrar;
    }

    public <T extends Message> void sendToClient(T message, ServerPlayer player) {
        if (this.registrar != null && message != null) {
            try {
                Method sendMethod = this.registrar.getClass().getMethod("send", Object.class, ServerPlayer.class);
                sendMethod.invoke((Object)this.registrar, message, player);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method sendToPlayer = this.registrar.getClass().getMethod("sendToPlayer", Object.class, ServerPlayer.class);
                    sendToPlayer.invoke((Object)this.registrar, message, player);
                }
                catch (Exception e2) {
                    try {
                        BiConsumer<?, MessageContext> handler = this.getClientboundHandler(message.getClass());
                        if (handler != null) {
                            ClientMessageContext ctx = new ClientMessageContext(player);
                            handler.accept(message, ctx);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public <T extends Message> BiConsumer<T, ? extends MessageContext> getClientboundHandler(Class<T> messageClass) {
        return this.clientboundHandlers.get(messageClass);
    }

    public <T extends Message> MessageBuilder<T, ServerMessageContext> serverbound(Supplier<T> factory) {
        return new MessageBuilder<T, ServerMessageContext>(factory, new HandlerConsumerFactory(LogicalSide.SERVER, ServerMessageContext::new));
    }

    public <T extends Message> MessageBuilder<T, ClientMessageContext> clientbound(Supplier<T> factory) {
        return new MessageBuilder(factory, EffectiveSide.get().isClient() ? new HandlerConsumerFactory(LogicalSide.CLIENT, ClientMessageContext::new) : new NoopConsumerFactory());
    }

    public NetBuilder build() {
        return this;
    }

    public class MessageBuilder<T extends Message, S extends MessageContext> {
        private final Supplier<T> factory;
        private final ConsumerFactory<T, S> consumerFactory;
        private final LogicalSide side;

        protected MessageBuilder(Supplier<T> factory, ConsumerFactory<T, S> consumerFactory) {
            this.factory = factory;
            this.consumerFactory = consumerFactory;
            this.side = consumerFactory instanceof HandlerConsumerFactory ? ((HandlerConsumerFactory)consumerFactory).side : LogicalSide.SERVER;
        }

        public NetBuilder consumer(Supplier<BiConsumer<? super T, S>> consumer) {
            Class<?> messageClass = ((Message)this.factory.get()).getClass();
            if (this.side == LogicalSide.CLIENT) {
                NetBuilder.this.clientboundHandlers.put(messageClass, consumer.get());
            } else {
                NetBuilder.this.serverboundHandlers.put(messageClass, consumer.get());
            }
            return NetBuilder.this;
        }
    }

    private static class HandlerConsumerFactory<T extends Message, S extends MessageContext>
    implements ConsumerFactory<T, S> {
        private final LogicalSide side;
        private final Function<Object, S> contextFactory;

        HandlerConsumerFactory(LogicalSide side, Function<Object, S> contextFactory) {
            this.side = side;
            this.contextFactory = contextFactory;
        }

        @Override
        public BiConsumer<T, Supplier<Object>> create(Supplier<BiConsumer<? super T, S>> handlerFactory) {
            BiConsumer<? super T, S> handler = handlerFactory.get();
            return (msg, ctx) -> {};
        }
    }

    static interface ConsumerFactory<T extends Message, S extends MessageContext> {
        public BiConsumer<T, Supplier<Object>> create(Supplier<BiConsumer<? super T, S>> var1);
    }

    private static class NoopConsumerFactory<T extends Message, S extends MessageContext>
    implements ConsumerFactory<T, S> {
        private NoopConsumerFactory() {
        }

        @Override
        public BiConsumer<T, Supplier<Object>> create(Supplier<BiConsumer<? super T, S>> handlerFactory) {
            return (msg, ctx) -> {};
        }
    }
}

