/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.serverbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.ServerMessageContext;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class EditLetteredConnectionMessage<C extends Connection>
extends ConnectionMessage
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<EditLetteredConnectionMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"edit_lettered_connection"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EditLetteredConnectionMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> msg.encode((FriendlyByteBuf)buf), EditLetteredConnectionMessage::new);
    private StyledString text;

    public EditLetteredConnectionMessage() {
    }

    public EditLetteredConnectionMessage(C connection, StyledString text) {
        super((Connection)connection);
        this.text = text;
    }

    private EditLetteredConnectionMessage(RegistryFriendlyByteBuf buf) {
        this.decode((FriendlyByteBuf)buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(EditLetteredConnectionMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ConnectionMessage.getConnection(message, c -> c instanceof Lettered, serverPlayer.level()).ifPresent(connection -> {
                    if (connection.isModifiable((Player)serverPlayer) && ((Lettered)((Object)connection)).isSupportedText(message.text)) {
                        ((Lettered)((Object)connection)).setText(message.text);
                    }
                });
            }
        });
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.writeNbt((Tag)StyledString.serialize(this.text));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.text = StyledString.deserialize(buf.readNbt());
    }

    public static final class Handler
    implements BiConsumer<EditLetteredConnectionMessage<?>, ServerMessageContext> {
        @Override
        public void accept(EditLetteredConnectionMessage<?> message, ServerMessageContext context) {
            ServerPlayer player = context.getPlayer();
            this.accept(message, player);
        }

        @Override
        private <C extends Connection> void accept(EditLetteredConnectionMessage<C> message, ServerPlayer player) {
            if (player != null) {
                ConnectionMessage.getConnection(message, c -> c instanceof Lettered, player.level()).ifPresent(connection -> {
                    if (connection.isModifiable((Player)player) && ((Lettered)((Object)connection)).isSupportedText(message.text)) {
                        ((Lettered)((Object)connection)).setText(message.text);
                    }
                });
            }
        }
    }
}

