/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.serverbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.ServerMessageContext;
import me.paulf.fairylights.util.Utils;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class InteractionConnectionMessage
extends ConnectionMessage
implements CustomPacketPayload {
    private static final float RANGE = 1089.0f;
    private static final float REACH = 36.0f;
    public static final CustomPacketPayload.Type<InteractionConnectionMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fairylights", (String)"interaction_connection"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InteractionConnectionMessage> STREAM_CODEC = StreamCodec.of((buf, msg) -> msg.encode((FriendlyByteBuf)buf), InteractionConnectionMessage::new);
    private PlayerAction type;
    private Vec3 hit;
    private FeatureType featureType;
    private int featureId;

    public InteractionConnectionMessage() {
    }

    public InteractionConnectionMessage(Connection connection, PlayerAction type, Intersection intersection) {
        super(connection);
        this.type = type;
        this.hit = intersection.getResult();
        this.featureType = intersection.getFeatureType();
        this.featureId = intersection.getFeature().getId();
    }

    private InteractionConnectionMessage(RegistryFriendlyByteBuf buf) {
        this.decode((FriendlyByteBuf)buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.hit.x);
        buf.writeDouble(this.hit.y);
        buf.writeDouble(this.hit.z);
        buf.writeVarInt(this.featureType.getId());
        buf.writeVarInt(this.featureId);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.type = Utils.getEnumValue(PlayerAction.class, buf.readUnsignedByte());
        this.hit = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.featureType = FeatureType.fromId(buf.readVarInt());
        this.featureId = buf.readVarInt();
    }

    public static void handle(InteractionConnectionMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ConnectionMessage.getConnection(message, c -> true, serverPlayer.level()).ifPresent(connection -> {
                    if (connection.isModifiable((Player)serverPlayer) && serverPlayer.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)connection.getFastener().getPos())) < 1089.0 && serverPlayer.distanceToSqr(message.hit.x, message.hit.y, message.hit.z) < 36.0) {
                        if (message.type == PlayerAction.ATTACK) {
                            connection.disconnect((Player)serverPlayer, message.hit);
                        } else {
                            InteractionConnectionMessage.interact(message, (Player)serverPlayer, connection, message.hit);
                        }
                    }
                });
            }
        });
    }

    private static void interact(InteractionConnectionMessage message, Player player, Connection connection, Vec3 hit) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            ItemStack oldStack = stack.copy();
            if (!connection.interact(player, hit, message.featureType, message.featureId, stack, hand)) continue;
            InteractionConnectionMessage.updateItem(player, oldStack, stack, hand);
            break;
        }
    }

    private static void updateItem(Player player, ItemStack oldStack, ItemStack stack, InteractionHand hand) {
        if (stack.getCount() <= 0 && !player.getAbilities().instabuild) {
            EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
            player.setItemInHand(hand, ItemStack.EMPTY);
        } else if (stack.getCount() < oldStack.getCount() && player.getAbilities().instabuild) {
            stack.setCount(oldStack.getCount());
        }
    }

    public static final class Handler
    implements BiConsumer<InteractionConnectionMessage, ServerMessageContext> {
        @Override
        public void accept(InteractionConnectionMessage message, ServerMessageContext context) {
            ServerPlayer player = context.getPlayer();
            ConnectionMessage.getConnection(message, c -> true, player.level()).ifPresent(connection -> {
                if (connection.isModifiable((Player)player) && player.distanceToSqr(Vec3.atLowerCornerOf((Vec3i)connection.getFastener().getPos())) < 1089.0 && player.distanceToSqr(message.hit.x, message.hit.y, message.hit.z) < 36.0) {
                    if (message.type == PlayerAction.ATTACK) {
                        connection.disconnect((Player)player, message.hit);
                    } else {
                        InteractionConnectionMessage.interact(message, (Player)player, connection, message.hit);
                    }
                }
            });
        }
    }
}

