/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class AABBBuilder {
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    public AABBBuilder() {
    }

    public AABBBuilder(BlockPos pos) {
        Objects.requireNonNull(pos, "pos");
        this.minX = pos.getX();
        this.maxX = this.minX + 1.0;
        this.minY = pos.getY();
        this.maxY = this.minY + 1.0;
        this.minZ = pos.getZ();
        this.maxZ = this.minZ + 1.0;
    }

    public AABBBuilder(Vec3 min, Vec3 max) {
        this(Objects.requireNonNull(min, (String)"min").x, min.y, min.z, Objects.requireNonNull(max, (String)"max").x, max.y, max.z);
    }

    public AABBBuilder(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.minX = Math.min(minX, maxX);
        this.minY = Math.min(minY, maxY);
        this.minZ = Math.min(minZ, maxZ);
        this.maxX = Math.max(minX, maxX);
        this.maxY = Math.max(minY, maxY);
        this.maxZ = Math.max(minZ, maxZ);
    }

    public AABBBuilder add(Vec3 point) {
        return this.add(Objects.requireNonNull(point, (String)"point").x, point.y, point.z);
    }

    public AABBBuilder add(Vec3i point) {
        return this.add(Objects.requireNonNull(point, "point").getX(), point.getY(), point.getZ());
    }

    public AABBBuilder add(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public AABBBuilder include(Vec3 point) {
        return this.include(Objects.requireNonNull(point, (String)"point").x, point.y, point.z);
    }

    public AABBBuilder include(double x, double y, double z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        return this;
    }

    public AABBBuilder expand(double amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public AABB build() {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public static AABB union(List<AABB> aabbs) {
        Objects.requireNonNull(aabbs, "AABBs");
        return AABBBuilder.union(aabbs, aabb -> aabb);
    }

    public static <T> AABB union(List<T> aabbs, Function<T, AABB> mapper) {
        Objects.requireNonNull(aabbs, "AABBs");
        Objects.requireNonNull(mapper, "mapper");
        Preconditions.checkArgument((aabbs.size() > 0 ? 1 : 0) != 0, (Object)"Must have more than zero AABBs");
        AABB bounds = mapper.apply(aabbs.get(0));
        if (aabbs.size() == 1) {
            return Objects.requireNonNull(bounds, "mapper returned bounds");
        }
        double minX = bounds.minX;
        double minY = bounds.minY;
        double minZ = bounds.minZ;
        double maxX = bounds.maxX;
        double maxY = bounds.maxY;
        double maxZ = bounds.maxZ;
        int size = aabbs.size();
        for (int i = 1; i < size; ++i) {
            bounds = Objects.requireNonNull(mapper.apply(aabbs.get(i)), "mapper returned bounds");
            minX = FLMth.min(minX, bounds.minX, bounds.maxX);
            minY = FLMth.min(minY, bounds.minY, bounds.maxY);
            minZ = FLMth.min(minZ, bounds.minZ, bounds.maxZ);
            maxX = FLMth.max(maxX, bounds.minX, bounds.maxX);
            maxY = FLMth.max(maxY, bounds.minY, bounds.maxY);
            maxZ = FLMth.max(maxZ, bounds.minZ, bounds.maxZ);
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

