/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import net.minecraft.util.Mth;

public final class CatenaryUtils {
    public static final int SEG_LENGTH = 3;
    private static final int MAX_ITER = 100;
    private static final float MIN_GRAD = 1.0E-10f;
    private static final float MIN_VAL = 1.0E-8f;
    private static final float STEP_DEC = 0.5f;
    private static final float MIN_STEP = 1.0E-9f;
    private static final float MIN_HORIZ = 0.001f;

    private CatenaryUtils() {
    }

    public static void catenary(float x1, float y1, float x2, float y2, float length, int pointCount, float[] x, float[] y) {
        CatenaryUtils.catenary(x1, y1, x2, y2, length, pointCount, x, y, 1.0f);
    }

    private static void catenary(float x1, float y1, float x2, float y2, float length, int pointCount, float[] x, float[] y, float sag) {
        if (x1 > x2) {
            float temp = x1;
            x1 = x2;
            x2 = temp;
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float d = x2 - x1;
        float h = y2 - y1;
        CatenaryUtils.linspace(x1, x2, pointCount, x, 0);
        if (Mth.abs((float)d) < 0.001f || length <= Mth.sqrt((float)(d * d + h * h))) {
            CatenaryUtils.linspace(y1, y2, pointCount, y, 0);
            return;
        }
        for (int iter = 0; iter < 100; ++iter) {
            float val = CatenaryUtils.g(sag, d, length, h);
            float grad = CatenaryUtils.dg(sag, d);
            if (Mth.abs((float)val) < 1.0E-8f || Mth.abs((float)grad) < 1.0E-10f) break;
            float search = -CatenaryUtils.g(sag, d, length, h) / CatenaryUtils.dg(sag, d);
            float alpha = 1.0f;
            float sagNew = sag + alpha * search;
            float valAbs = Mth.abs((float)val);
            while ((sagNew < 0.0f || Mth.abs((float)CatenaryUtils.g(sagNew, d, length, h)) > valAbs) && !((alpha = 0.5f * alpha) < 1.0E-9f)) {
                sagNew = sag + alpha * search;
            }
            sag = sagNew;
        }
        float xLeft = 0.5f * ((float)Math.log((length + h) / (length - h)) / sag - d);
        float xMin = x1 - xLeft;
        float bias = y1 - (float)Math.cosh(xLeft * sag) / sag;
        for (int i = 0; i < pointCount; ++i) {
            y[i] = (float)Math.cosh((x[i] - xMin) * sag) / sag + bias;
        }
    }

    private static float dg(float s, float d) {
        return 2.0f * (float)Math.cosh(s * d / 2.0f) * d / (2.0f * s) - 2.0f * (float)Math.sinh(s * d / 2.0f) / (s * s);
    }

    private static float g(float s, float d, float length, float h) {
        return 2.0f * (float)Math.sinh(s * d / 2.0f) / s - Mth.sqrt((float)(length * length - h * h));
    }

    private static void linspace(float base, float limit, int n, float[] elements, int offset) {
        float scalar = n > 1 ? (limit - base) / (float)(n - 1) : 0.0f;
        for (int i = 0; i < n; ++i) {
            elements[offset + i] = base + scalar * (float)i;
        }
    }
}

