/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public final class OreDictUtils {
    private OreDictUtils() {
    }

    public static boolean isDye(ItemStack stack) {
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof DyeItem) {
                return true;
            }
            return stack.is(Tags.Items.DYES);
        }
        return false;
    }

    public static DyeColor getDyeColor(ItemStack stack) {
        if (!stack.isEmpty()) {
            if (stack.getItem() instanceof DyeItem) {
                return ((DyeItem)stack.getItem()).getDyeColor();
            }
            for (Dye dye : Dye.values()) {
                if (!stack.is(dye.getName())) continue;
                return dye.getColor();
            }
        }
        return DyeColor.YELLOW;
    }

    public static ImmutableList<ItemStack> getDyes(DyeColor color) {
        return OreDictUtils.getDyeItemStacks().get((Object)color).asList();
    }

    public static ImmutableList<ItemStack> getAllDyes() {
        return OreDictUtils.getDyeItemStacks().values().asList();
    }

    private static ImmutableMultimap<DyeColor, ItemStack> getDyeItemStacks() {
        ImmutableMultimap.Builder bob = ImmutableMultimap.builder();
        for (Dye dye : Dye.values()) {
            boolean found = false;
            for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(dye.getName())) {
                bob.put((Object)dye.getColor(), (Object)new ItemStack(holder));
                found = true;
            }
            if (found) continue;
            bob.put((Object)dye.getColor(), (Object)new ItemStack((ItemLike)DyeItem.byColor((DyeColor)dye.getColor())));
        }
        return bob.build();
    }

    private static enum Dye {
        WHITE((TagKey<Item>)Tags.Items.DYES_WHITE, DyeColor.WHITE),
        ORANGE((TagKey<Item>)Tags.Items.DYES_ORANGE, DyeColor.ORANGE),
        MAGENTA((TagKey<Item>)Tags.Items.DYES_MAGENTA, DyeColor.MAGENTA),
        LIGHT_BLUE((TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE, DyeColor.LIGHT_BLUE),
        YELLOW((TagKey<Item>)Tags.Items.DYES_YELLOW, DyeColor.YELLOW),
        LIME((TagKey<Item>)Tags.Items.DYES_LIME, DyeColor.LIME),
        PINK((TagKey<Item>)Tags.Items.DYES_PINK, DyeColor.PINK),
        GRAY((TagKey<Item>)Tags.Items.DYES_GRAY, DyeColor.GRAY),
        LIGHT_GRAY((TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY, DyeColor.LIGHT_GRAY),
        CYAN((TagKey<Item>)Tags.Items.DYES_CYAN, DyeColor.CYAN),
        PURPLE((TagKey<Item>)Tags.Items.DYES_PURPLE, DyeColor.PURPLE),
        BLUE((TagKey<Item>)Tags.Items.DYES_BLUE, DyeColor.BLUE),
        BROWN((TagKey<Item>)Tags.Items.DYES_BROWN, DyeColor.BROWN),
        GREEN((TagKey<Item>)Tags.Items.DYES_GREEN, DyeColor.GREEN),
        RED((TagKey<Item>)Tags.Items.DYES_RED, DyeColor.RED),
        BLACK((TagKey<Item>)Tags.Items.DYES_BLACK, DyeColor.BLACK);

        private final TagKey<Item> name;
        private final DyeColor color;

        private Dye(TagKey<Item> name, DyeColor color) {
            this.name = name;
            this.color = color;
        }

        private TagKey<Item> getName() {
            return this.name;
        }

        private DyeColor getColor() {
            return this.color;
        }
    }
}

