/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.locale.Language;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;

public final class Utils {
    private Utils() {
    }

    public static <E extends Enum<E>> E getEnumValue(Class<E> clazz, int ordinal) {
        Enum[] values = (Enum[])Objects.requireNonNull(clazz, "clazz").getEnumConstants();
        return (E)values[ordinal < 0 || ordinal >= values.length ? 0 : ordinal];
    }

    public static Component formatRecipeTooltip(String key) {
        return Utils.formatRecipeTooltipValue(Language.getInstance().getOrDefault(key));
    }

    private static Component formatRecipeTooltipValue(String value) {
        return Component.translatable((String)"recipe.ingredient.tooltip", (Object[])new Object[]{value});
    }

    public static boolean impliesNbt(@Nullable Tag antecedent, @Nullable Tag consequent) {
        if (antecedent == consequent) {
            return true;
        }
        if (antecedent == null != (consequent == null)) {
            return false;
        }
        if (!antecedent.getClass().equals(consequent.getClass())) {
            return false;
        }
        if (antecedent instanceof CompoundTag) {
            for (String key : ((CompoundTag)antecedent).getAllKeys()) {
                if (Utils.impliesNbt(((CompoundTag)antecedent).get(key), ((CompoundTag)consequent).get(key))) continue;
                return false;
            }
            return true;
        }
        return antecedent.equals((Object)consequent);
    }
}

