/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.crafting.ingredient;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class LazyTagIngredient {
    private final Ingredient ingredient;
    private final TagKey<Item> tag;

    private LazyTagIngredient(TagKey<Item> tag) {
        this.tag = tag;
        this.ingredient = Ingredient.of(StreamSupport.stream(BuiltInRegistries.ITEM.getTagOrEmpty(tag).spliterator(), false).map(ItemStack::new));
    }

    public ItemStack[] getItems() {
        return this.ingredient.getItems();
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public IntList getStackingIds() {
        return this.ingredient.getStackingIds();
    }

    public boolean isEmpty() {
        return this.ingredient.isEmpty();
    }

    public Ingredient asIngredient() {
        return this.ingredient;
    }

    public static LazyTagIngredient of(TagKey<Item> tag) {
        return new LazyTagIngredient(tag);
    }
}

