/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.util.styledstring;

import net.minecraft.ChatFormatting;

public final class Style
implements Comparable<Style> {
    private static final int COLOR_MASK = 15;
    private static final int OBFUSCATED_MASK = 16;
    private static final int BOLD_MASK = 32;
    private static final int STRIKETHROUGH_MASK = 64;
    private static final int UNDERLINE_MASK = 128;
    private static final int ITALIC_MASK = 256;
    private static final int FANCY_MASK = 496;
    private final int value;

    public Style() {
        this(ChatFormatting.WHITE, false, false, false, false, false);
    }

    public Style(ChatFormatting color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic, boolean isObfuscated) {
        this(Style.pack(color, isBold, isStrikethrough, isUnderline, isItalic, isObfuscated));
    }

    public Style(int value) {
        this.value = value;
    }

    public int packed() {
        return this.value;
    }

    public ChatFormatting getColor() {
        return ChatFormatting.getById((int)(this.value & 0xF));
    }

    public boolean isObfuscated() {
        return (this.value & 0x10) != 0;
    }

    public boolean isBold() {
        return (this.value & 0x20) != 0;
    }

    public boolean isStrikethrough() {
        return (this.value & 0x40) != 0;
    }

    public boolean isUnderline() {
        return (this.value & 0x80) != 0;
    }

    public boolean isItalic() {
        return (this.value & 0x100) != 0;
    }

    public boolean isPlain() {
        return (this.value & 0x1F0) == 0;
    }

    public Style withColor(ChatFormatting color) {
        if (!color.isColor()) {
            throw new IllegalArgumentException("Invalid color formatting: " + color.getName());
        }
        return new Style(color.getId() | this.value & 0x1F0);
    }

    public Style withBold(boolean isBold) {
        return new Style(isBold ? this.value | 0x20 : this.value & 0xFFFFFFDF);
    }

    public Style withStrikethrough(boolean isStrikethrough) {
        return new Style(isStrikethrough ? this.value | 0x40 : this.value & 0xFFFFFFBF);
    }

    public Style withUnderline(boolean isUnderline) {
        return new Style(isUnderline ? this.value | 0x80 : this.value & 0xFFFFFF7F);
    }

    public Style withItalic(boolean isItalic) {
        return new Style(isItalic ? this.value | 0x100 : this.value & 0xFFFFFEFF);
    }

    public Style withObfuscated(boolean isObfuscated) {
        return new Style(isObfuscated ? this.value | 0x10 : this.value & 0xFFFFFFEF);
    }

    public Style withStyling(ChatFormatting formatting, boolean state) {
        if (formatting.isColor()) {
            return this.withColor(formatting);
        }
        switch (formatting) {
            case BOLD: {
                return this.withBold(state);
            }
            case STRIKETHROUGH: {
                return this.withStrikethrough(state);
            }
            case UNDERLINE: {
                return this.withUnderline(state);
            }
            case ITALIC: {
                return this.withItalic(state);
            }
            case OBFUSCATED: {
                return this.withObfuscated(state);
            }
        }
        throw new IllegalArgumentException("Invalid fancy formatting: " + formatting.getName());
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Style && this.value == ((Style)obj).value;
    }

    @Override
    public int compareTo(Style other) {
        if (this == other) {
            return 0;
        }
        return this.value - other.value;
    }

    private static int pack(ChatFormatting color, boolean isBold, boolean isStrikethrough, boolean isUnderline, boolean isItalic, boolean isObfuscated) {
        if (!color.isColor()) {
            throw new IllegalArgumentException("Invalid color formatting: " + color.getName());
        }
        int value = color.getId();
        if (isObfuscated) {
            value |= 0x10;
        }
        if (isBold) {
            value |= 0x20;
        }
        if (isStrikethrough) {
            value |= 0x40;
        }
        if (isUnderline) {
            value |= 0x80;
        }
        if (isItalic) {
            value |= 0x100;
        }
        return value;
    }
}

