/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.states.HalfBlockStates;
import com.wenxin2.marioverse.registries.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BridgeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<HalfBlockStates> HALF = EnumProperty.create((String)"half", HalfBlockStates.class);
    public Block logBlock;
    protected static final VoxelShape BOTTOM_AABB_X = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)16.0), Block.box((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0)}).optimize();
    protected static final VoxelShape TOP_AABB_X = Shapes.or((VoxelShape)Block.box((double)1.0, (double)13.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)12.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0), Block.box((double)12.0, (double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0)}).optimize();
    protected static final VoxelShape BOTTOM_AABB_Z = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)4.0, (double)10.0), Block.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)3.0, (double)15.0)}).optimize();
    protected static final VoxelShape TOP_AABB_Z = Shapes.or((VoxelShape)Block.box((double)0.0, (double)13.0, (double)1.0, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0), Block.box((double)0.0, (double)13.0, (double)12.0, (double)16.0, (double)16.0, (double)15.0)}).optimize();
    protected static final VoxelShape BOTTOM_COLLISION = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_COLLISION = Block.box((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BridgeBlock(Block logBlock, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(HALF, (Comparable)((Object)HalfBlockStates.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.logBlock = logBlock;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{AXIS, HALF, WATERLOGGED});
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        HalfBlockStates stateValue = (HalfBlockStates)((Object)state.getValue(HALF));
        if (axis == Direction.Axis.X) {
            if (stateValue == HalfBlockStates.TOP) {
                return TOP_AABB_X;
            }
            return BOTTOM_AABB_X;
        }
        if (stateValue == HalfBlockStates.TOP) {
            return TOP_AABB_Z;
        }
        return BOTTOM_AABB_Z;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        EntityCollisionContext context;
        HalfBlockStates stateValue = (HalfBlockStates)((Object)state.getValue(HALF));
        if (collisionContext instanceof EntityCollisionContext && (context = (EntityCollisionContext)collisionContext).getEntity() != null && (stateValue == HalfBlockStates.TOP ? !context.isAbove(BOTTOM_COLLISION, pos, false) : stateValue == HalfBlockStates.BOTTOM && !context.isAbove(TOP_COLLISION, pos.below(), false))) {
            return Shapes.empty();
        }
        return super.getCollisionShape(state, blockGetter, pos, collisionContext);
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    default -> state;
                };
            }
        }
        return state;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        BlockPos pos = placeContext.getClickedPos();
        FluidState fluidState = placeContext.getLevel().getFluidState(pos);
        Direction direction = placeContext.getHorizontalDirection();
        BlockState state = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)direction.getAxis())).setValue(HALF, (Comparable)((Object)HalfBlockStates.BOTTOM))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return !(direction == Direction.DOWN || direction != Direction.UP && placeContext.getClickLocation().y - (double)pos.getY() > 0.5) ? state : (BlockState)state.setValue(HALF, (Comparable)((Object)HalfBlockStates.TOP));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (itemAbility.equals(ItemAbilities.AXE_STRIP)) {
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String path = id.getPath();
            String logName = BuiltInRegistries.BLOCK.getKey((Object)this.logBlock).getPath();
            if (!path.contains("stripped_") && (path.contains("bamboo_bridge") || path.contains("log_bridge") || path.contains("stem_bridge"))) {
                String removeBlockName = logName.replace("_block", "");
                String strippedPath = path.replace(removeBlockName, "stripped_" + removeBlockName);
                ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)strippedPath);
                Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(strippedId);
                if (strippedBlock != Blocks.AIR && strippedId.getPath().contains("stripped_")) {
                    return (BlockState)((BlockState)((BlockState)strippedBlock.defaultBlockState().setValue(AXIS, (Comparable)((Direction.Axis)state.getValue(AXIS)))).setValue(HALF, (Comparable)((Object)((HalfBlockStates)((Object)state.getValue(HALF)))))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)));
                }
            }
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.is(TagRegistry.FLAMMABLE_WOODEN_BRIDGE_BLOCKS);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }
}

