/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.entities.CoinBlockEntity;
import com.wenxin2.marioverse.entities.GoldKoopaShellEntity;
import com.wenxin2.marioverse.entities.KoopaShellEntity;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoinBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape COIN_SHAPE = Block.box((double)3.0, (double)2.5, (double)3.0, (double)14.0, (double)14.5, (double)14.0).optimize();

    public CoinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{WATERLOGGED});
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return COIN_SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CoinBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidState = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor worldAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldAccessor));
        }
        return super.updateShape(state, direction, neighborState, worldAccessor, pos, neighborPos);
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        Player player;
        Projectile projectile;
        ItemStack coinItem = new ItemStack((ItemLike)this.asItem());
        if (entity instanceof KoopaShellEntity) {
            KoopaShellEntity koopaShell = (KoopaShellEntity)entity;
            if (!(entity instanceof GoldKoopaShellEntity) && koopaShell.getOwner() != null && koopaShell.getOwner().getType().is(TagRegistry.CAN_COLLECT_COINS)) {
                CoinBlock.collectCoin(world, state, pos, koopaShell.getOwner(), coinItem);
                return;
            }
        }
        if (entity instanceof Projectile && (projectile = (Projectile)entity).getOwner() != null) {
            CoinBlock.collectCoin(world, state, pos, projectile.getOwner(), coinItem);
            return;
        }
        if (!entity.getType().is(TagRegistry.CAN_COLLECT_COINS)) return;
        if ((Boolean)ConfigRegistry.COINS_COLLECTED_ON_COLLISION.get() == false) return;
        if (entity instanceof Player && (player = (Player)entity).isCreative() && !((Boolean)ConfigRegistry.COINS_COLLECTED_IN_CREATIVE.get()).booleanValue()) {
            return;
        }
        CoinBlock.collectCoin(world, state, pos, entity, coinItem);
    }

    public static void collectCoin(Level world, BlockState state, BlockPos pos, Entity entity, ItemStack coinItem) {
        LivingEntity livingEntity;
        LivingEntity livingEntity2;
        boolean itemAdded = false;
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerParticleUtils.spawnParticlesOnBlockFaces((ParticleOptions)ParticleRegistry.COIN_GLINT.get(), serverWorld, pos, (IntProvider)UniformInt.of((int)1, (int)1));
        }
        world.playSound(null, pos, (SoundEvent)SoundRegistry.COIN_PICKUP.get(), SoundSource.BLOCKS);
        world.removeBlock(pos, false);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemAdded = player.addItem(coinItem);
            if (!itemAdded) {
                player.drop(coinItem, false);
            }
            if (state.is(BlockTags.GUARDED_BY_PIGLINS)) {
                PiglinAi.angerNearbyPiglins((Player)player, (boolean)false);
            }
        } else if (entity instanceof LivingEntity && (livingEntity2 = (LivingEntity)entity).getMainHandItem().isEmpty()) {
            livingEntity2.setItemInHand(InteractionHand.MAIN_HAND, coinItem);
            livingEntity2.swing(InteractionHand.MAIN_HAND);
            itemAdded = true;
        } else if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).getOffhandItem().isEmpty()) {
            livingEntity.setItemInHand(InteractionHand.OFF_HAND, coinItem);
            livingEntity.swing(InteractionHand.OFF_HAND);
            itemAdded = true;
        } else if (entity instanceof InventoryCarrier) {
            InventoryCarrier carrier = (InventoryCarrier)entity;
            SimpleContainer inventory = carrier.getInventory();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity3 = (LivingEntity)entity;
                livingEntity3.swing(InteractionHand.MAIN_HAND);
            }
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                if (!inventory.getItem(i).isEmpty()) continue;
                inventory.setItem(i, coinItem);
                itemAdded = true;
                break;
            }
        } else if (entity instanceof Container) {
            Container container = (Container)entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity4 = (LivingEntity)entity;
                livingEntity4.swing(InteractionHand.MAIN_HAND);
            }
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.getItem(i).isEmpty()) continue;
                container.setItem(i, coinItem);
                itemAdded = true;
                break;
            }
        }
        if (!itemAdded) {
            entity.spawnAtLocation(coinItem);
        }
    }
}

