/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.entities.WarpDoorBlockEntity;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpDoorBlock
extends DoorBlock
implements EntityBlock {
    private final DoorBlock source;

    public WarpDoorBlock(DoorBlock source) {
        super(source.type(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source));
        this.source = source;
    }

    public DoorBlock source() {
        return this.source;
    }

    @NotNull
    public MutableComponent getName() {
        return Component.translatable((String)"block.marioverse.warp_door", (Object[])new Object[]{Component.translatable((String)this.source.getDescriptionId())});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpDoorBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        BlockEntity blockEntityAbove = world.getBlockEntity(pos.above());
        BlockEntity blockEntityBelow = world.getBlockEntity(pos.below());
        UUID uuid = UUID.randomUUID();
        if (blockEntity instanceof WarpDoorBlockEntity) {
            CustomData data;
            WarpDoorBlockEntity doorBE = (WarpDoorBlockEntity)blockEntity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos, 16);
            }
            if ((data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null && data.copyTag().hasUUID("UUID")) {
                doorBE.setUUID(data.copyTag().getUUID("UUID"));
                doorBE.setChanged();
                if (blockEntityAbove instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEAbove = (WarpDoorBlockEntity)blockEntityAbove;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos.above(), 16);
                    }
                    doorBEAbove.setUUID(data.copyTag().getUUID("UUID"));
                    doorBEAbove.setChanged();
                } else if (blockEntityBelow instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEBelow = (WarpDoorBlockEntity)blockEntityBelow;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos.below(), 16);
                    }
                    doorBEBelow.setUUID(data.copyTag().getUUID("UUID"));
                    doorBEBelow.setChanged();
                }
            } else {
                doorBE.setUUID(uuid);
                doorBE.setChanged();
                if (blockEntityAbove instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEAbove = (WarpDoorBlockEntity)blockEntityAbove;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos.above(), 16);
                    }
                    doorBEAbove.setUUID(uuid);
                    doorBEAbove.setChanged();
                } else if (blockEntityBelow instanceof WarpDoorBlockEntity) {
                    WarpDoorBlockEntity doorBEBelow = (WarpDoorBlockEntity)blockEntityBelow;
                    if (world instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        ServerParticleUtils.spawnThreeLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos.below(), 16);
                    }
                    doorBEBelow.setUUID(uuid);
                    doorBEBelow.setChanged();
                }
            }
            doorBE.onLoad();
        }
        super.setPlacedBy(world, pos, state, entity, stack);
    }
}

