/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks;

import com.wenxin2.marioverse.blocks.entities.WarpTrapDoorBlockEntity;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpTrapDoorBlock
extends TrapDoorBlock
implements EntityBlock {
    private final TrapDoorBlock source;

    public WarpTrapDoorBlock(TrapDoorBlock source) {
        super(source.getType(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source));
        this.source = source;
    }

    public TrapDoorBlock source() {
        return this.source;
    }

    @NotNull
    public MutableComponent getName() {
        return Component.translatable((String)"block.marioverse.warp_trapdoor", (Object[])new Object[]{Component.translatable((String)this.source.getDescriptionId())});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltip) {
        ResourceLocation blockID = BuiltInRegistries.BLOCK.getKey((Object)this.source);
        Component modName = (Component)ModList.get().getModContainerById(blockID.getNamespace()).map(c -> Component.literal((String)c.getModInfo().getDisplayName())).orElse(Component.literal((String)blockID.getNamespace()));
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.literal((String)""));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip.ability"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip.description"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip.guide"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip.mod"));
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip.source_mod", (Object[])new Object[]{modName}).withStyle(ChatFormatting.BLUE));
            list.add((Component)Component.literal((String)""));
        } else {
            list.add((Component)Component.translatable((String)"block.marioverse.warp_trapdoor.tooltip"));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WarpTrapDoorBlockEntity(pos, state);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof WarpTrapDoorBlockEntity) {
            CustomData data;
            WarpTrapDoorBlockEntity doorBE = (WarpTrapDoorBlockEntity)blockEntity;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                ServerParticleUtils.spawnOneLayerBlockParticles((ParticleOptions)ParticleTypes.PORTAL, serverWorld, null, pos, 16);
            }
            if ((data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null && data.copyTag().hasUUID("UUID")) {
                doorBE.setUUID(data.copyTag().getUUID("UUID"));
                doorBE.setChanged();
            } else {
                UUID uuid = UUID.randomUUID();
                doorBE.setUUID(uuid);
                doorBE.setChanged();
            }
            doorBE.onLoad();
        }
        super.setPlacedBy(world, pos, state, entity, stack);
    }

    public boolean skipRendering(BlockState state, BlockState neighborState, Direction direction) {
        return state.is(CompatRegistry.MV_FRAMED_GLASS_TRAPDOOR.get()) == neighborState.is(CompatRegistry.MV_FRAMED_GLASS_TRAPDOOR.get()) && WarpTrapDoorBlock.isConnected(state, neighborState, direction);
    }

    public static boolean isConnected(BlockState state, BlockState neighborState, Direction direction) {
        if (state.is(CompatRegistry.MV_FRAMED_GLASS_TRAPDOOR.get()) && neighborState.is(CompatRegistry.MV_FRAMED_GLASS_TRAPDOOR.get())) {
            state = (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
            neighborState = (BlockState)((BlockState)neighborState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
            boolean isOpen = (Boolean)state.getValue((Property)OPEN);
            Half half = (Half)state.getValue((Property)HALF);
            Direction facing = (Direction)state.getValue((Property)FACING);
            if (isOpen != (Boolean)neighborState.getValue((Property)OPEN)) {
                return false;
            }
            if (!isOpen && half == neighborState.getValue((Property)HALF)) {
                return direction.getAxis() != Direction.Axis.Y;
            }
            if (!isOpen && half != neighborState.getValue((Property)HALF) && direction.getAxis() == Direction.Axis.Y) {
                return true;
            }
            if (isOpen && facing.getOpposite() == neighborState.getValue((Property)FACING) && direction.getAxis() == facing.getAxis()) {
                return true;
            }
            if ((isOpen ? (BlockState)state.setValue((Property)HALF, (Comparable)Half.TOP) : state) != (isOpen ? (BlockState)neighborState.setValue((Property)HALF, (Comparable)Half.TOP) : neighborState)) {
                return false;
            }
            return direction.getAxis() != facing.getAxis();
        }
        return false;
    }
}

