/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks.behaviors;

import com.wenxin2.marioverse.blocks.SplunkinCarvedPumpkinBlock;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class DispenserBehaviors {
    public static void register() {
        DefaultDispenseItemBehavior dispenseBucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource blockSource, ItemStack stack) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)stack.getItem();
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, pos, null, stack)) {
                    dispensibleContainerItem.checkExtraContent(null, (Level)level, stack, pos);
                    return this.consumeWithRemainder(blockSource, stack, new ItemStack((ItemLike)Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(blockSource, stack);
            }
        };
        DefaultDispenseItemBehavior dispensePlasticBucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource blockSource, ItemStack stack) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)stack.getItem();
                BlockPos pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel level = blockSource.level();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, pos, null, stack)) {
                    dispensibleContainerItem.checkExtraContent(null, (Level)level, stack, pos);
                    return this.consumeWithRemainder(blockSource, stack, new ItemStack((ItemLike)ItemRegistry.PLASTIC_BUCKET.get()));
                }
                return this.defaultDispenseItemBehavior.dispense(blockSource, stack);
            }
        };
        DispenserBlock.registerProjectileBehavior(ItemRegistry.LARGE_SNOWBALL);
        DispenserBlock.registerBehavior(ItemRegistry.QUICKSAND_BUCKET, (DispenseItemBehavior)dispenseBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.PLASTIC_QUICKSAND_BUCKET, (DispenseItemBehavior)dispensePlasticBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.RED_QUICKSAND_BUCKET, (DispenseItemBehavior)dispenseBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.PLASTIC_RED_QUICKSAND_BUCKET, (DispenseItemBehavior)dispensePlasticBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.PLASTIC_POWDER_SNOW_BUCKET, (DispenseItemBehavior)dispensePlasticBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.PLASTIC_WATER_BUCKET, (DispenseItemBehavior)dispensePlasticBucketBehavior);
        DispenserBlock.registerBehavior(ItemRegistry.PLASTIC_BUCKET, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack execute(BlockSource blockSource, ItemStack stack) {
                ItemStack newStack;
                BlockPos pos;
                ServerLevel level = blockSource.level();
                BlockState state = level.getBlockState(pos = blockSource.pos().relative((Direction)blockSource.state().getValue((Property)DispenserBlock.FACING)));
                Block block = state.getBlock();
                if (!(block instanceof BucketPickup)) {
                    return super.execute(blockSource, stack);
                }
                BucketPickup bucketPickup = (BucketPickup)block;
                if (state.is((Block)BlockRegistry.QUICKSAND.get())) {
                    newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_QUICKSAND_BUCKET.get());
                } else if (state.is((Block)BlockRegistry.RED_QUICKSAND.get())) {
                    newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_RED_QUICKSAND_BUCKET.get());
                } else if (state.is(Blocks.POWDER_SNOW)) {
                    newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_POWDER_SNOW_BUCKET.get());
                } else if (state.is(Blocks.WATER)) {
                    newStack = new ItemStack((ItemLike)ItemRegistry.PLASTIC_WATER_BUCKET.get());
                } else {
                    return super.execute(blockSource, stack);
                }
                newStack.applyComponents(stack.getComponents());
                ItemStack vanillaResult = bucketPickup.pickupBlock(null, (LevelAccessor)level, pos, state);
                if (vanillaResult.isEmpty()) {
                    return super.execute(blockSource, stack);
                }
                level.gameEvent(null, (Holder)GameEvent.FLUID_PICKUP, pos);
                return this.consumeWithRemainder(blockSource, stack, newStack);
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)BlockRegistry.SPLUNKIN_CARVED_PUMPKIN.get()), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                ServerLevel world = source.level();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                CarvedPumpkinBlock carvedPumpkinBlock = (CarvedPumpkinBlock)BlockRegistry.SPLUNKIN_CARVED_PUMPKIN.get();
                if (world.isEmptyBlock(blockpos)) {
                    if (!world.isClientSide) {
                        world.setBlock(blockpos, carvedPumpkinBlock.defaultBlockState(), 3);
                        world.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, blockpos);
                    }
                    stack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ArmorItem.dispenseArmor((BlockSource)source, (ItemStack)stack));
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.PUMPKIN_PIE, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                ServerLevel world = source.level();
                Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos targetPos = source.pos().relative(facing);
                BlockState targetState = world.getBlockState(targetPos);
                if (targetState.hasProperty((Property)SplunkinCarvedPumpkinBlock.CRACKED) && ((Boolean)targetState.getValue((Property)SplunkinCarvedPumpkinBlock.CRACKED)).booleanValue()) {
                    world.setBlock(targetPos, (BlockState)targetState.setValue((Property)SplunkinCarvedPumpkinBlock.CRACKED, (Comparable)Boolean.valueOf(false)), 3);
                    world.playSound(null, targetPos, SoundEvents.GENERIC_EAT, SoundSource.BLOCKS);
                    stack.shrink(1);
                }
                return stack;
            }
        });
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                ServerLevel world = source.level();
                Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                BlockPos targetPos = source.pos().relative(facing);
                BlockState targetState = world.getBlockState(targetPos);
                if (targetState.hasProperty((Property)SplunkinCarvedPumpkinBlock.CRACKED) && !((Boolean)targetState.getValue((Property)SplunkinCarvedPumpkinBlock.CRACKED)).booleanValue()) {
                    world.setBlock(targetPos, (BlockState)targetState.setValue((Property)SplunkinCarvedPumpkinBlock.CRACKED, (Comparable)Boolean.valueOf(true)), 3);
                    world.levelEvent(null, 2001, targetPos, Block.getId((BlockState)targetState));
                    world.playSound(null, targetPos, (SoundEvent)SoundRegistry.SPLUNKIN_CRACKS.get(), SoundSource.BLOCKS);
                    stack.hurtAndBreak(1, world, null, item -> {});
                }
                return stack;
            }
        });
    }
}

