/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.blocks.entities;

import com.wenxin2.marioverse.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.marioverse.registries.BlockEntityRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.utils.BlockWarpEntityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class WarpTrapDoorBlockEntity
extends BaseWarpBlockEntity {
    public static final String BREAK_TRAPDOOR = "BreakTrapdoor";
    public boolean breakTrapdoor;

    public WarpTrapDoorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityRegistry.WARP_TRAPDOOR_BLOCK_ENTITY.get(), pos, state);
    }

    public WarpTrapDoorBlockEntity(BlockEntityType<?> tileEntity, BlockPos pos, BlockState state) {
        super(tileEntity, pos, state);
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state) || state.getBlock() instanceof TrapDoorBlock;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(BREAK_TRAPDOOR)) {
            this.breakTrapdoor = tag.getBoolean(BREAK_TRAPDOOR);
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putBoolean(BREAK_TRAPDOOR, this.breakTrapdoor);
    }

    public void setBreakTrapdoor(boolean breakTrapdoor) {
        this.breakTrapdoor = breakTrapdoor;
    }

    public static void breakTrapdoor(BlockPos warpPos, Level world) {
        if (!world.isClientSide && world.getBlockState(warpPos).getBlock() instanceof TrapDoorBlock) {
            world.destroyBlock(warpPos, true);
        }
    }

    public static void warp(Entity entity, BlockPos warpPos, Level world, BlockState state, TrapDoorBlock trapdoorBlock, BaseWarpBlockEntity warpBE) {
        LivingEntity passengerEntity = entity.getControllingPassenger();
        if (!((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            Player player;
            if (!(world.getBlockEntity(warpPos) instanceof BaseWarpBlockEntity) && entity instanceof Player) {
                player = (Player)entity;
                BlockWarpEntityHandler.displayDestinationMissingMessage(player);
            }
            if (entity instanceof Player) {
                player = (Player)entity;
                if (state.getBlock() instanceof TrapDoorBlock) {
                    warpBE.playTrapdoorSounds(null, world, warpPos, (Boolean)state.getValue((Property)TrapDoorBlock.OPEN), trapdoorBlock.getType());
                }
                entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                entity.setData(DataAttachmentRegistry.WARP_COOLDOWN, (Object)((Integer)ConfigRegistry.WARP_TRAPDOOR_COOLDOWN.get()));
                if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                }
            } else {
                if (state.getBlock() instanceof TrapDoorBlock) {
                    warpBE.playTrapdoorSounds(entity, world, warpPos, (Boolean)state.getValue((Property)TrapDoorBlock.OPEN), trapdoorBlock.getType());
                }
                entity.teleportTo((double)warpPos.getX() + 0.5, (double)warpPos.getY(), (double)warpPos.getZ() + 0.5);
                entity.setData(DataAttachmentRegistry.WARP_COOLDOWN, (Object)((Integer)ConfigRegistry.WARP_TRAPDOOR_COOLDOWN.get()));
                if (passengerEntity instanceof Player) {
                    Player player2 = (Player)passengerEntity;
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player2.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                    entity.unRide();
                }
            }
        }
        WarpTrapDoorBlockEntity.markEntityTeleported(entity);
        world.gameEvent((Holder)GameEvent.TELEPORT, warpPos, GameEvent.Context.of((Entity)entity));
    }
}

