/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.client.models.entities.FireGoombaModel;
import com.wenxin2.marioverse.entities.FireGoombaEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class FireGoombaRenderer
extends GeoEntityRenderer<FireGoombaEntity> {
    private static final String HELMET = "armorBipedHead";

    public FireGoombaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FireGoombaModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<FireGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, FireGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case FireGoombaRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, FireGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case FireGoombaRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, FireGoombaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case FireGoombaRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 0.94f);
                poseStack.translate(0.0f, 0.0f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<FireGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, FireGoombaEntity animatable) {
                BlockItem blockItem;
                Object object;
                if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (object = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)object).getBlock() instanceof SkullBlock)) {
                    return switch (bone.getName()) {
                        case FireGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                        default -> null;
                    };
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, FireGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case FireGoombaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, FireGoombaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.scale(0.6f, 0.6f, 0.55f);
                poseStack.translate(0.0f, 0.5f, 0.0f);
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(FireGoombaEntity animatable) {
        return 0.0f;
    }

    public void renderFinal(PoseStack poseStack, FireGoombaEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
        this.model.getBone("wick").ifPresent(wick -> {
            Vector3d wickPos = wick.getWorldPosition();
            if (animatable.isInWaterOrBubble()) {
                if (animatable.tickCount % 8 == 0) {
                    animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SMOKE, wickPos.x(), wickPos.y() + 0.2, wickPos.z(), 0.0, 0.0, 0.0);
                }
            } else if (animatable.tickCount % 8 == 0) {
                animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.FLAME, wickPos.x(), wickPos.y() + 0.2, wickPos.z(), 0.0, 0.0, 0.0);
                animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SMOKE, wickPos.x(), wickPos.y() + 0.2, wickPos.z(), 0.0, 0.0, 0.0);
            }
        });
        this.model.getBone("left_eyebrow_pivot").ifPresent(brow -> {
            Vector3d browPos = brow.getWorldPosition();
            Vec3 forward = animatable.getLookAngle().normalize().scale(0.2);
            if (animatable.tickCount % 8 == 0 && animatable.isInWaterOrBubble()) {
                animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SMOKE, browPos.x() + forward.x, browPos.y() + forward.y, browPos.z() + forward.z, 0.0, 0.0, 0.0);
            }
        });
        this.model.getBone("right_eyebrow_pivot").ifPresent(brow -> {
            Vector3d browPos = brow.getWorldPosition();
            Vec3 forward = animatable.getLookAngle().normalize().scale(0.2);
            if (animatable.tickCount % 8 == 0 && animatable.isInWaterOrBubble()) {
                animatable.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SMOKE, browPos.x() + forward.x, browPos.y() + forward.y, browPos.z() + forward.z, 0.0, 0.0, 0.0);
            }
        });
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, color);
    }
}

