/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wenxin2.marioverse.client.models.entities.MiniGoombaModel;
import com.wenxin2.marioverse.entities.MiniGoombaEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class MiniGoombaRenderer
extends GeoEntityRenderer<MiniGoombaEntity> {
    private static final String HELMET = "armorBipedHead";

    public MiniGoombaRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MiniGoombaModel());
        this.shadowRadius = 0.125f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<MiniGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, MiniGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MiniGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, MiniGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MiniGoombaRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, MiniGoombaEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case MiniGoombaRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.0f, 1.0f, 0.94f);
                poseStack.translate(0.0f, 0.0f, 0.0f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<MiniGoombaEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, MiniGoombaEntity animatable) {
                BlockItem blockItem;
                Object object;
                if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (object = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)object).getBlock() instanceof SkullBlock)) {
                    return switch (bone.getName()) {
                        case MiniGoombaRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                        default -> null;
                    };
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, MiniGoombaEntity animatable) {
                return switch (bone.getName()) {
                    case MiniGoombaRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, MiniGoombaEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                poseStack.scale(0.6f, 0.6f, 0.55f);
                poseStack.translate(0.0f, 0.5f, 0.0f);
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected float getDeathMaxRotation(MiniGoombaEntity animatable) {
        return 0.0f;
    }
}

