/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.client.models.entities.PokeyModel;
import com.wenxin2.marioverse.entities.PokeyEntity;
import com.wenxin2.marioverse.entities.SnowPokeyEntity;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class PokeyRenderer
extends GeoEntityRenderer<PokeyEntity> {
    private static final String HELMET = "armorBipedHead";

    public PokeyRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new PokeyModel());
        this.shadowRadius = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<PokeyEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, PokeyEntity animatable) {
                return switch (bone.getName()) {
                    case PokeyRenderer.HELMET -> animatable.getItemBySlot(EquipmentSlot.HEAD);
                    default -> null;
                };
            }

            @NotNull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, PokeyEntity animatable) {
                return switch (bone.getName()) {
                    case PokeyRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @NotNull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, PokeyEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case PokeyRenderer.HELMET -> baseModel.head;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }

            protected void renderSkullAsArmor(PoseStack poseStack, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, MultiBufferSource bufferSource, int packedLight) {
                poseStack.scale(1.35f, 1.35f, 1.35f);
                super.renderSkullAsArmor(poseStack, bone, stack, skullBlock, bufferSource, packedLight);
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<PokeyEntity>(this, (GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, PokeyEntity animatable) {
                return switch (bone.getName()) {
                    case PokeyRenderer.HELMET -> {
                        BlockItem blockItem;
                        Item var6_5;
                        if (!(animatable.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ArmorItem || (var6_5 = animatable.getItemBySlot(EquipmentSlot.HEAD).getItem()) instanceof BlockItem && (blockItem = (BlockItem)var6_5).getBlock() instanceof SkullBlock)) {
                            yield animatable.getItemBySlot(EquipmentSlot.HEAD);
                        }
                        yield ItemStack.EMPTY;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, PokeyEntity animatable) {
                return switch (bone.getName()) {
                    case PokeyRenderer.HELMET -> ItemDisplayContext.HEAD;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, PokeyEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack.getItem() instanceof BlockItem) {
                    poseStack.scale(1.15f, 1.15f, 1.15f);
                    poseStack.translate(0.0f, 0.5f, 0.0f);
                } else {
                    poseStack.translate(0.0f, 0.2f, 0.0f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public void preRender(PoseStack poseStack, PokeyEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        this.model.getBone("spikes").ifPresent(spike -> {
            spike.setHidden(false);
            if (!animatable.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                spike.setHidden(true);
            }
        });
        if (animatable instanceof PokeyEntity) {
            this.model.getBone("flower").ifPresent(flower -> {
                if (!((Boolean)animatable.getData(DataAttachmentRegistry.HAS_FLOWER)).booleanValue()) {
                    flower.setHidden(true);
                } else {
                    flower.setHidden(false);
                }
            });
        }
        if (animatable instanceof SnowPokeyEntity) {
            this.model.getBone("nose").ifPresent(nose -> {
                if (!((Boolean)animatable.getData(DataAttachmentRegistry.HAS_CARROT)).booleanValue()) {
                    nose.setHidden(true);
                } else {
                    nose.setHidden(false);
                }
            });
            this.model.getBone("golden_nose").ifPresent(nose -> {
                if (!((Boolean)animatable.getData(DataAttachmentRegistry.HAS_GOLDEN_CARROT)).booleanValue()) {
                    nose.setHidden(true);
                } else {
                    nose.setHidden(false);
                }
            });
        }
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    protected float getDeathMaxRotation(PokeyEntity animatable) {
        if (animatable instanceof SnowPokeyEntity) {
            return 0.0f;
        }
        return super.getDeathMaxRotation((Entity)animatable);
    }
}

