/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.wenxin2.marioverse.items.DashMushroomItem;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.vehicle.VehicleEntity;

public class PowerUpCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"powerup").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"dash_mushroom").then(Commands.argument((String)"boostStrength", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)50.0)).executes(ctx -> PowerUpCommand.applyDashMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"boostStrength"))))).executes(ctx -> PowerUpCommand.applyDashMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), 1.0)))).then(((LiteralArgumentBuilder)Commands.literal((String)"fire_flower").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "fire_flower"))).then(Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applyPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "fire_flower", BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"ice_flower").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "ice_flower"))).then(Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applyPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "ice_flower", BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"super_mushroom").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "super_mushroom"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"manualOverride", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PowerUpCommand.applySuperMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), BoolArgumentType.getBool((CommandContext)ctx, (String)"manualOverride"))))).executes(ctx -> PowerUpCommand.applySuperMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), true))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mega_mushroom").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "mega_mushroom"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)Commands.argument((String)"maxHealth", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).then(((RequiredArgumentBuilder)Commands.argument((String)"stepHeight", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10.0)).then(Commands.argument((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(ctx -> PowerUpCommand.applyMegaMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"maxHealth"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"stepHeight"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"durationTicks"))))).executes(ctx -> PowerUpCommand.applyMegaMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"maxHealth"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"stepHeight"), -1)))).executes(ctx -> PowerUpCommand.applyMegaMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"maxHealth"), 0.0, -1)))).executes(ctx -> PowerUpCommand.applyMegaMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), 0.0, 0.0, -1))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mini_mushroom").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "mini_mushroom"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"maxHealth", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)100.0)).executes(ctx -> PowerUpCommand.applyMiniMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"maxHealth"))))).executes(ctx -> PowerUpCommand.applyMiniMushroom((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), 0.0))))).then(((LiteralArgumentBuilder)Commands.literal((String)"super_star").executes(ctx -> PowerUpCommand.hasPowerUp((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), "super_star"))).then(((RequiredArgumentBuilder)Commands.argument((String)"enablePowerUp", (ArgumentType)BoolArgumentType.bool()).then(Commands.argument((String)"durationTicks", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(ctx -> PowerUpCommand.applySuperStar((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"durationTicks"))))).executes(ctx -> PowerUpCommand.applySuperStar((CommandSourceStack)ctx.getSource(), EntityArgument.getEntities((CommandContext)ctx, (String)"targets"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enablePowerUp"), -1))))));
    }

    private static void applyPowerUpType(Entity entity, String powerUpName, boolean enablePowerUp) {
        switch (powerUpName) {
            case "fire_flower": {
                entity.setData(DataAttachmentRegistry.HAS_FIRE_FLOWER, (Object)enablePowerUp);
                break;
            }
            case "ice_flower": {
                entity.setData(DataAttachmentRegistry.HAS_ICE_FLOWER, (Object)enablePowerUp);
            }
        }
    }

    private static int applyPowerUp(CommandSourceStack source, Collection<? extends Entity> targets, String powerUpName, boolean enablePowerUp) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                PowerUpCommand.applyPowerUpType(entity, powerUpName, enablePowerUp);
                ++count;
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                if (count != 1) continue;
                switch (powerUpName) {
                    case "fire_flower": {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$21((Component)powerUpBoolean, entity), true);
                        break;
                    }
                    case "ice_flower": {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$22((Component)powerUpBoolean, entity), true);
                    }
                }
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            switch (powerUpName) {
                case "fire_flower": {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$24((Component)powerUpBoolean, finalCount), true);
                    break;
                }
                case "ice_flower": {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyPowerUp$25((Component)powerUpBoolean, finalCount), true);
                }
            }
        }
        return count;
    }

    private static int applyDashMushroom(CommandSourceStack source, Collection<? extends Entity> targets, double boostStrength) {
        int count = 0;
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                entity.setData(DataAttachmentRegistry.HAS_DASH_MUSHROOM_BOOST, (Object)true);
                DashMushroomItem.mushroomAbilities(null, livingEntity.level(), livingEntity, boostStrength, false, true);
                entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                if (++count != 1) continue;
                if (entity.getVehicle() != null) {
                    source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom", (Object[])new Object[]{boostStrength, entity.getVehicle().getDisplayName()}), true);
                    continue;
                }
                source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom", (Object[])new Object[]{boostStrength, entity.getDisplayName()}), true);
                continue;
            }
            if (entity instanceof VehicleEntity) {
                source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up_boost.fail", (Object[])new Object[]{entity.getDisplayName()}).withStyle(ChatFormatting.RED), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.dash_mushroom.count", (Object[])new Object[]{boostStrength, finalCount}), true);
        }
        return count;
    }

    private static int applyMegaMushroom(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, double maxHealth, double stepHeight, int durationTicks) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        MutableComponent maxHealthStyle = Component.translatable((String)"commands.marioverse.power_up.max_health", (Object[])new Object[]{maxHealth / 2.0}).withStyle(ChatFormatting.RED);
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                AttributeInstance healthAttribute = livingEntity.getAttribute(Attributes.MAX_HEALTH);
                AttributeInstance stepAttribute = livingEntity.getAttribute(Attributes.STEP_HEIGHT);
                entity.setData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM, (Object)enablePowerUp);
                entity.setData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM, (Object)true);
                livingEntity.heal((float)maxHealth * 2.0f);
                ++count;
                if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM)).booleanValue()) {
                    entity.setData(DataAttachmentRegistry.HAS_MINI_MUSHROOM, (Object)false);
                }
                AttributesRegistry.updateAttributeModifiers(stepAttribute, AttributesRegistry.AUTO_STEP_HEIGHT, stepHeight, stepHeight != 0.0, false);
                AttributesRegistry.updateAttributeModifiers(healthAttribute, AttributesRegistry.MAX_HEATH, (double)(-livingEntity.getMaxHealth()) + maxHealth, !entity.getType().is(TagRegistry.CANNOT_CHANGE_MAX_HEALTH) && maxHealth != 0.0, (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM) == false || !enablePowerUp);
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_MEGA_MUSHROOM.get(), SoundSource.AMBIENT);
                }
                if (durationTicks >= 0) {
                    entity.setData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION, (Object)durationTicks);
                } else {
                    entity.setData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION, (Object)-1);
                }
                if (count != 1) continue;
                if (enablePowerUp) {
                    if (maxHealth != 0.0) {
                        source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$31((Component)powerUpBoolean, entity, (Component)maxHealthStyle, durationTicks), true);
                        continue;
                    }
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$32((Component)powerUpBoolean, entity, durationTicks), true);
                    continue;
                }
                if (maxHealth != 0.0) {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$33((Component)powerUpBoolean, entity, (Component)maxHealthStyle), true);
                    continue;
                }
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$34((Component)powerUpBoolean, entity), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            if (enablePowerUp) {
                if (maxHealth != 0.0) {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$36((Component)powerUpBoolean, finalCount, (Component)maxHealthStyle, durationTicks), true);
                } else {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$37((Component)powerUpBoolean, finalCount, durationTicks), true);
                }
            } else {
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMegaMushroom$38((Component)powerUpBoolean, finalCount), true);
            }
        }
        return count;
    }

    private static int applyMiniMushroom(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, double maxHealth) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        MutableComponent maxHealthStyle = Component.translatable((String)"commands.marioverse.power_up.max_health", (Object[])new Object[]{maxHealth / 2.0}).withStyle(ChatFormatting.RED);
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                AttributeInstance healthAttribute = livingEntity.getAttribute(Attributes.MAX_HEALTH);
                entity.setData(DataAttachmentRegistry.HAS_MINI_MUSHROOM, (Object)enablePowerUp);
                entity.setData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM, (Object)(!enablePowerUp ? 1 : 0));
                livingEntity.heal((float)maxHealth * 2.0f);
                ++count;
                if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM)).booleanValue()) {
                    entity.setData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM, (Object)false);
                    entity.setData(DataAttachmentRegistry.MEGA_MUSHROOM_DURATION, (Object)0);
                }
                AttributesRegistry.updateAttributeModifiers(healthAttribute, AttributesRegistry.MAX_HEATH, (double)(-livingEntity.getMaxHealth()) + maxHealth, !entity.getType().is(TagRegistry.CANNOT_CHANGE_MAX_HEALTH) && maxHealth != 0.0, (Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM) == false || !enablePowerUp);
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_MINI_MUSHROOM.get(), SoundSource.AMBIENT);
                }
                if (count != 1) continue;
                if (maxHealth != 0.0) {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applyMiniMushroom$39((Component)powerUpBoolean, entity, (Component)maxHealthStyle), true);
                    continue;
                }
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMiniMushroom$40((Component)powerUpBoolean, entity), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            if (maxHealth != 0.0) {
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMiniMushroom$42((Component)powerUpBoolean, finalCount, (Component)maxHealthStyle), true);
            } else {
                source.sendSuccess(() -> PowerUpCommand.lambda$applyMiniMushroom$43((Component)powerUpBoolean, finalCount), true);
            }
        }
        return count;
    }

    private static int applySuperMushroom(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, boolean manualOverride) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                entity.setData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM, (Object)enablePowerUp);
                entity.setData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE, (Object)manualOverride);
                ++count;
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                } else {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.DAMAGE_TAKEN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                }
                if (count != 1) continue;
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperMushroom$44((Component)powerUpBoolean, entity), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            source.sendSuccess(() -> PowerUpCommand.lambda$applySuperMushroom$46((Component)powerUpBoolean, finalCount), true);
        }
        return count;
    }

    private static int applySuperStar(CommandSourceStack source, Collection<? extends Entity> targets, boolean enablePowerUp, int durationTicks) {
        int count = 0;
        MutableComponent powerUpBoolean = Component.translatable((String)(enablePowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
        for (Entity entity : targets) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Object)enablePowerUp);
                ++count;
                if (enablePowerUp) {
                    entity.level().playSound(null, entity.blockPosition(), (SoundEvent)SoundRegistry.POWERS_UP_SUPER_STAR.get(), SoundSource.AMBIENT);
                }
                if (durationTicks >= 0) {
                    entity.setData(DataAttachmentRegistry.SUPER_STAR_DURATION, (Object)durationTicks);
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, durationTicks, 4, true, false));
                } else {
                    entity.setData(DataAttachmentRegistry.SUPER_STAR_DURATION, (Object)-1);
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, -1, 4, true, false));
                }
                if (count != 1) continue;
                if (enablePowerUp) {
                    source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$47((Component)powerUpBoolean, entity, durationTicks), true);
                    continue;
                }
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$48((Component)powerUpBoolean, entity), true);
                continue;
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.marioverse.power_up.fail"), true);
        }
        int finalCount = count;
        if (finalCount > 1) {
            if (enablePowerUp) {
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$50((Component)powerUpBoolean, finalCount, durationTicks), true);
            } else {
                source.sendSuccess(() -> PowerUpCommand.lambda$applySuperStar$51((Component)powerUpBoolean, finalCount), true);
            }
        }
        return count;
    }

    private static int hasPowerUp(CommandSourceStack source, Collection<? extends Entity> targets, String powerUpName) {
        int count = 0;
        int falseCount = 0;
        ArrayList<MutableComponent> singleResults = new ArrayList<MutableComponent>();
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            boolean hasPowerUp = switch (powerUpName) {
                case "fire_flower" -> (Boolean)entity.getData(DataAttachmentRegistry.HAS_FIRE_FLOWER);
                case "ice_flower" -> (Boolean)entity.getData(DataAttachmentRegistry.HAS_ICE_FLOWER);
                case "mega_mushroom" -> (Boolean)entity.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM);
                case "mini_mushroom" -> (Boolean)entity.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM);
                case "super_mushroom" -> {
                    if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM)).booleanValue() || ((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM_OVERRIDE)).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case "super_star" -> (Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR);
                default -> false;
            };
            MutableComponent powerUpBoolean = Component.translatable((String)(hasPowerUp ? "commands.marioverse.boolean.true" : "commands.marioverse.boolean.false"));
            if (hasPowerUp) {
                ++count;
            } else {
                ++falseCount;
            }
            if (targets.size() != 1) continue;
            singleResults.add(Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value"), (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()}));
        }
        if (singleResults.size() == 1) {
            source.sendSuccess(singleResults::getFirst, true);
        }
        if (targets.size() > 1) {
            MutableComponent powerUpBoolean;
            if (count > 0) {
                powerUpBoolean = Component.translatable((String)"commands.marioverse.boolean.true");
                int n = count;
                source.sendSuccess(() -> PowerUpCommand.lambda$hasPowerUp$52(powerUpName, (Component)powerUpBoolean, n), true);
            }
            if (falseCount > 0) {
                powerUpBoolean = Component.translatable((String)"commands.marioverse.boolean.false");
                int n = falseCount;
                source.sendSuccess(() -> PowerUpCommand.lambda$hasPowerUp$53(powerUpName, (Component)powerUpBoolean, n), true);
            }
        }
        return count + falseCount;
    }

    private static /* synthetic */ Component lambda$hasPowerUp$53(String powerUpName, Component powerUpBoolean, int finalFalseCount) {
        return Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value.count"), (Object[])new Object[]{powerUpBoolean, finalFalseCount});
    }

    private static /* synthetic */ Component lambda$hasPowerUp$52(String powerUpName, Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)("commands.marioverse.power_up." + powerUpName + ".value.count"), (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applySuperStar$51(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applySuperStar$50(Component powerUpBoolean, int finalCount, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.ticks.count", (Object[])new Object[]{powerUpBoolean, finalCount, durationTicks});
    }

    private static /* synthetic */ Component lambda$applySuperStar$48(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applySuperStar$47(Component powerUpBoolean, Entity entity, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.super_star.ticks", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), durationTicks});
    }

    private static /* synthetic */ Component lambda$applySuperMushroom$46(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.super_mushroom.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applySuperMushroom$44(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.super_mushroom", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyMiniMushroom$43(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.mini_mushroom.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyMiniMushroom$42(Component powerUpBoolean, int finalCount, Component maxHealthStyle) {
        return Component.translatable((String)"commands.marioverse.power_up.mini_mushroom.max_health.count", (Object[])new Object[]{powerUpBoolean, finalCount, maxHealthStyle});
    }

    private static /* synthetic */ Component lambda$applyMiniMushroom$40(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.mini_mushroom", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyMiniMushroom$39(Component powerUpBoolean, Entity entity, Component maxHealthStyle) {
        return Component.translatable((String)"commands.marioverse.power_up.mini_mushroom.max_health", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), maxHealthStyle});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$38(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$37(Component powerUpBoolean, int finalCount, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.ticks.count", (Object[])new Object[]{powerUpBoolean, finalCount, durationTicks});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$36(Component powerUpBoolean, int finalCount, Component maxHealthStyle, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.max_health.ticks.count", (Object[])new Object[]{powerUpBoolean, finalCount, maxHealthStyle, durationTicks});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$34(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$33(Component powerUpBoolean, Entity entity, Component maxHealthStyle) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.max_health", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), maxHealthStyle});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$32(Component powerUpBoolean, Entity entity, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.ticks", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), durationTicks});
    }

    private static /* synthetic */ Component lambda$applyMegaMushroom$31(Component powerUpBoolean, Entity entity, Component maxHealthStyle, int durationTicks) {
        return Component.translatable((String)"commands.marioverse.power_up.mega_mushroom.max_health.ticks", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName(), maxHealthStyle, durationTicks});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$25(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.ice_flower.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$24(Component powerUpBoolean, int finalCount) {
        return Component.translatable((String)"commands.marioverse.power_up.fire_flower.count", (Object[])new Object[]{powerUpBoolean, finalCount});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$22(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.ice_flower", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }

    private static /* synthetic */ Component lambda$applyPowerUp$21(Component powerUpBoolean, Entity entity) {
        return Component.translatable((String)"commands.marioverse.power_up.fire_flower", (Object[])new Object[]{powerUpBoolean, entity.getDisplayName()});
    }
}

