/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.dynamic_pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.wenxin2.marioverse.event_handlers.RegistryEventHandlers;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class DynamicClientResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, byte[]> resources = new HashMap<ResourceLocation, byte[]>();
    private final PackLocationInfo location;

    public DynamicClientResources(PackLocationInfo location) {
        this.location = location;
        this.generateBlockstates();
        this.generateItemModels();
    }

    public IoSupplier<InputStream> getRootResource(String ... path) {
        if (path.length == 1 && path[0].equals("pack.mcmeta")) {
            JsonObject root = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES));
            pack.addProperty("description", "Prevents \"Unable to find model\" for warp doors & trapdoors");
            root.add("pack", (JsonElement)pack);
            byte[] bytes = root.toString().getBytes(StandardCharsets.UTF_8);
            return () -> new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (type != PackType.CLIENT_RESOURCES) {
            return null;
        }
        byte[] data = this.resources.get(location);
        return data != null ? () -> new ByteArrayInputStream(data) : null;
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        if (type != PackType.CLIENT_RESOURCES && !namespace.equals("marioverse")) {
            return;
        }
        for (Map.Entry<ResourceLocation, byte[]> entry : this.resources.entrySet()) {
            ResourceLocation blockID = entry.getKey();
            if (!blockID.getNamespace().equals(namespace) || !blockID.getPath().startsWith(path)) continue;
            output.accept((Object)blockID, () -> new ByteArrayInputStream((byte[])entry.getValue()));
        }
    }

    public Set<String> getNamespaces(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? Set.of("marioverse") : Set.of();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) throws IOException {
        T object;
        IoSupplier<InputStream> iosupplier = this.getRootResource("pack.mcmeta");
        if (iosupplier == null) {
            return null;
        }
        try (InputStream inputstream = (InputStream)iosupplier.get();){
            object = DynamicClientResources.getMetadataFromStream(serializer, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionSerializer<T> serializer, InputStream input) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.parse((Reader)bufferedreader);
        }
        catch (Exception exception1) {
            LOGGER.error("Couldn't load {} metadata", (Object)serializer.getMetadataSectionName(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(serializer.getMetadataSectionName())) {
            return null;
        }
        try {
            return (T)serializer.fromJson(GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)serializer.getMetadataSectionName()));
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load {} metadata", (Object)serializer.getMetadataSectionName(), (Object)exception);
            return null;
        }
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public void close() {
    }

    private void generateBlockstates() {
        ResourceLocation blockstateId;
        ResourceLocation blockID;
        JsonObject json = new JsonObject();
        JsonObject variants = new JsonObject();
        JsonObject model = new JsonObject();
        model.addProperty("model", "minecraft:block/air");
        variants.add("", (JsonElement)model);
        json.add("variants", (JsonElement)variants);
        byte[] bytes = json.toString().getBytes(StandardCharsets.UTF_8);
        for (Block warp : RegistryEventHandlers.WARP_DOORS.values()) {
            blockID = BuiltInRegistries.BLOCK.getKey((Object)warp);
            blockstateId = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("blockstates/" + blockID.getPath() + ".json"));
            this.resources.put(blockstateId, bytes);
        }
        for (Block warp : RegistryEventHandlers.WARP_TRAPDOORS.values()) {
            blockID = BuiltInRegistries.BLOCK.getKey((Object)warp);
            blockstateId = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("blockstates/" + blockID.getPath() + ".json"));
            this.resources.put(blockstateId, bytes);
        }
    }

    private void generateItemModels() {
        JsonObject textures;
        JsonObject json;
        ResourceLocation modelId;
        ResourceLocation blockID;
        for (Block warp : RegistryEventHandlers.WARP_DOORS.values()) {
            blockID = BuiltInRegistries.BLOCK.getKey((Object)warp);
            modelId = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("models/item/" + blockID.getPath() + ".json"));
            json = new JsonObject();
            json.addProperty("parent", "minecraft:item/generated");
            textures = new JsonObject();
            textures.addProperty("layer0", "minecraft:item/oak_door");
            json.add("textures", (JsonElement)textures);
            this.resources.put(modelId, json.toString().getBytes(StandardCharsets.UTF_8));
        }
        for (Block warp : RegistryEventHandlers.WARP_TRAPDOORS.values()) {
            blockID = BuiltInRegistries.BLOCK.getKey((Object)warp);
            modelId = ResourceLocation.fromNamespaceAndPath((String)blockID.getNamespace(), (String)("models/item/" + blockID.getPath() + ".json"));
            json = new JsonObject();
            json.addProperty("parent", "minecraft:item/generated");
            textures = new JsonObject();
            textures.addProperty("layer0", "minecraft:item/oak_door");
            json.add("textures", (JsonElement)textures);
            this.resources.put(modelId, json.toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

