/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.dynamic_pack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.wenxin2.marioverse.event_handlers.RegistryEventHandlers;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class DynamicServerResources
implements PackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, byte[]> lootTables = new HashMap<ResourceLocation, byte[]>();
    private final PackLocationInfo location;
    private static final Set<TagKey<Block>> DOOR_BLOCK_TAGS = Set.of(TagRegistry.WARP_DOOR_BLOCKS, BlockTags.DOORS, BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.WOODEN_DOORS);
    private static final Set<TagKey<Item>> DOOR_ITEM_TAGS = Set.of(TagRegistry.WARP_DOOR_ITEMS, ItemTags.DOORS, ItemTags.WOODEN_DOORS);
    private static final Set<TagKey<Block>> TRAPDOOR_BLOCK_TAGS = Set.of(TagRegistry.WARP_TRAPDOOR_BLOCKS, BlockTags.TRAPDOORS, BlockTags.MINEABLE_WITH_PICKAXE, BlockTags.WOODEN_TRAPDOORS);
    private static final Set<TagKey<Item>> TRAPDOOR_ITEM_TAGS = Set.of(TagRegistry.WARP_TRAPDOOR_ITEMS, ItemTags.TRAPDOORS, ItemTags.WOODEN_TRAPDOORS);

    public DynamicServerResources(PackLocationInfo location) {
        this.location = location;
        this.generateLootTables();
    }

    private void generateLootTables() {
        JsonObject json;
        ResourceLocation lootId;
        ResourceLocation warpId;
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_DOORS.entrySet()) {
            warpId = BuiltInRegistries.BLOCK.getKey((Object)entry.getValue());
            lootId = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)("blocks/" + warpId.getPath() + ".json"));
            json = DynamicServerResources.createDoorLootTable(warpId);
            this.lootTables.put(lootId, json.toString().getBytes(StandardCharsets.UTF_8));
        }
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_TRAPDOORS.entrySet()) {
            warpId = BuiltInRegistries.BLOCK.getKey((Object)entry.getValue());
            lootId = ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)("blocks/" + warpId.getPath() + ".json"));
            json = DynamicServerResources.createTrapDoorLootTable(warpId);
            this.lootTables.put(lootId, json.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public IoSupplier<InputStream> getRootResource(String ... path) {
        if (path.length == 1 && path[0].equals("pack.mcmeta")) {
            JsonObject root = new JsonObject();
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA));
            pack.addProperty("description", "Marioverse dynamic data for warp doors & trapdoors");
            root.add("pack", (JsonElement)pack);
            byte[] bytes = root.toString().getBytes(StandardCharsets.UTF_8);
            return () -> new ByteArrayInputStream(bytes);
        }
        return null;
    }

    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation location) {
        if (type != PackType.SERVER_DATA) {
            return null;
        }
        for (TagKey<Block> tagKey : DOOR_BLOCK_TAGS) {
            if (!location.equals((Object)tagKey.location().withPrefix("tags/block/").withSuffix(".json"))) continue;
            return this.buildDoorBlockTag(tagKey);
        }
        for (TagKey<Block> tagKey : DOOR_ITEM_TAGS) {
            if (!location.equals((Object)tagKey.location().withPrefix("tags/item/").withSuffix(".json"))) continue;
            return this.buildDoorItemTag(tagKey);
        }
        for (TagKey<Block> tagKey : TRAPDOOR_BLOCK_TAGS) {
            if (!location.equals((Object)tagKey.location().withPrefix("tags/block/").withSuffix(".json"))) continue;
            return this.buildTrapDoorBlockTag(tagKey);
        }
        for (TagKey<Block> tagKey : TRAPDOOR_ITEM_TAGS) {
            if (!location.equals((Object)tagKey.location().withPrefix("tags/item/").withSuffix(".json"))) continue;
            return this.buildTrapDoorItemTag(tagKey);
        }
        byte[] data = this.lootTables.get(location);
        if (data != null) {
            return () -> new ByteArrayInputStream(data);
        }
        return null;
    }

    public void listResources(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        ResourceLocation out;
        ResourceLocation id;
        if (type != PackType.SERVER_DATA) {
            return;
        }
        if (path.equals("tags/block")) {
            for (TagKey<Block> tagKey : DOOR_BLOCK_TAGS) {
                id = tagKey.location();
                if (!id.getNamespace().equals(namespace)) continue;
                out = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("tags/block/" + id.getPath() + ".json"));
                output.accept((Object)out, () -> (InputStream)this.buildDoorBlockTag(tag).get());
            }
            for (TagKey<Block> tagKey : TRAPDOOR_BLOCK_TAGS) {
                id = tagKey.location();
                if (!id.getNamespace().equals(namespace)) continue;
                out = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("tags/block/" + id.getPath() + ".json"));
                output.accept((Object)out, () -> (InputStream)this.buildTrapDoorBlockTag(tag).get());
            }
        }
        if (path.equals("tags/item")) {
            for (TagKey<Block> tagKey : DOOR_ITEM_TAGS) {
                id = tagKey.location();
                if (!id.getNamespace().equals(namespace)) continue;
                out = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("tags/item/" + id.getPath() + ".json"));
                output.accept((Object)out, () -> (InputStream)this.buildDoorItemTag((TagKey<Item>)tag).get());
            }
        }
        if (path.equals("tags/item")) {
            for (TagKey<Block> tagKey : TRAPDOOR_ITEM_TAGS) {
                id = tagKey.location();
                if (!id.getNamespace().equals(namespace)) continue;
                out = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("tags/item/" + id.getPath() + ".json"));
                output.accept((Object)out, () -> (InputStream)this.buildTrapDoorItemTag((TagKey<Item>)tag).get());
            }
        }
        if (path.equals("loot_table")) {
            for (Map.Entry entry : this.lootTables.entrySet()) {
                ResourceLocation blockID = (ResourceLocation)entry.getKey();
                if (!blockID.getNamespace().equals(namespace)) continue;
                out = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("loot_table/" + blockID.getPath()));
                output.accept((Object)out, () -> new ByteArrayInputStream((byte[])entry.getValue()));
            }
        }
    }

    @NotNull
    public Set<String> getNamespaces(PackType type) {
        return type == PackType.SERVER_DATA ? Set.of("minecraft", "marioverse") : Set.of();
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) throws IOException {
        T object;
        IoSupplier<InputStream> iosupplier = this.getRootResource("pack.mcmeta");
        if (iosupplier == null) {
            return null;
        }
        try (InputStream inputstream = (InputStream)iosupplier.get();){
            object = DynamicServerResources.getMetadataFromStream(serializer, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T getMetadataFromStream(MetadataSectionSerializer<T> serializer, InputStream input) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            jsonobject = GsonHelper.parse((Reader)bufferedreader);
        }
        catch (Exception exception1) {
            LOGGER.error("Couldn't load {} metadata", (Object)serializer.getMetadataSectionName(), (Object)exception1);
            return null;
        }
        if (!jsonobject.has(serializer.getMetadataSectionName())) {
            return null;
        }
        try {
            return (T)serializer.fromJson(GsonHelper.getAsJsonObject((JsonObject)jsonobject, (String)serializer.getMetadataSectionName()));
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load {} metadata", (Object)serializer.getMetadataSectionName(), (Object)exception);
            return null;
        }
    }

    public PackLocationInfo location() {
        return this.location;
    }

    public void close() {
    }

    private IoSupplier<InputStream> buildDoorBlockTag(TagKey<Block> tag) {
        JsonObject json = new JsonObject();
        JsonArray values = new JsonArray();
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_DOORS.entrySet()) {
            Block source = entry.getKey();
            Block warp = entry.getValue();
            if (!(source instanceof DoorBlock)) continue;
            DoorBlock door = (DoorBlock)source;
            boolean isWooden = door.type().canOpenByHand();
            if (tag.equals((Object)BlockTags.DOORS) && isWooden || tag.equals((Object)BlockTags.MINEABLE_WITH_PICKAXE) && isWooden || tag.equals((Object)BlockTags.WOODEN_DOORS) && !isWooden) continue;
            values.add(BuiltInRegistries.BLOCK.getKey((Object)warp).toString());
        }
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("values", (JsonElement)values);
        byte[] data = json.toString().getBytes(StandardCharsets.UTF_8);
        return () -> new ByteArrayInputStream(data);
    }

    private IoSupplier<InputStream> buildTrapDoorBlockTag(TagKey<Block> tag) {
        JsonObject json = new JsonObject();
        JsonArray values = new JsonArray();
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_TRAPDOORS.entrySet()) {
            Block source = entry.getKey();
            Block warp = entry.getValue();
            if (!(source instanceof TrapDoorBlock)) continue;
            TrapDoorBlock trapDoor = (TrapDoorBlock)source;
            boolean isWooden = trapDoor.getType().canOpenByHand();
            if (tag.equals((Object)BlockTags.TRAPDOORS) && isWooden || tag.equals((Object)BlockTags.MINEABLE_WITH_PICKAXE) && isWooden || tag.equals((Object)BlockTags.WOODEN_TRAPDOORS) && !isWooden) continue;
            values.add(BuiltInRegistries.BLOCK.getKey((Object)warp).toString());
        }
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("values", (JsonElement)values);
        byte[] data = json.toString().getBytes(StandardCharsets.UTF_8);
        return () -> new ByteArrayInputStream(data);
    }

    private IoSupplier<InputStream> buildDoorItemTag(TagKey<Item> tag) {
        JsonObject json = new JsonObject();
        JsonArray values = new JsonArray();
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_DOORS.entrySet()) {
            Block source = entry.getKey();
            Block warp = entry.getValue();
            if (!(source instanceof DoorBlock)) continue;
            DoorBlock door = (DoorBlock)source;
            boolean isWooden = door.type().canOpenByHand();
            if (tag.equals((Object)ItemTags.DOORS) && isWooden || tag.equals((Object)ItemTags.WOODEN_DOORS) && !isWooden) continue;
            values.add(BuiltInRegistries.ITEM.getKey((Object)warp.asItem()).toString());
        }
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("values", (JsonElement)values);
        byte[] data = json.toString().getBytes(StandardCharsets.UTF_8);
        return () -> new ByteArrayInputStream(data);
    }

    private IoSupplier<InputStream> buildTrapDoorItemTag(TagKey<Item> tag) {
        JsonObject json = new JsonObject();
        JsonArray values = new JsonArray();
        for (Map.Entry<Block, Block> entry : RegistryEventHandlers.WARP_TRAPDOORS.entrySet()) {
            Block source = entry.getKey();
            Block warp = entry.getValue();
            if (!(source instanceof TrapDoorBlock)) continue;
            TrapDoorBlock trapDoor = (TrapDoorBlock)source;
            boolean isWooden = trapDoor.getType().canOpenByHand();
            if (tag.equals((Object)ItemTags.TRAPDOORS) && isWooden || tag.equals((Object)ItemTags.WOODEN_TRAPDOORS) && !isWooden) continue;
            values.add(BuiltInRegistries.ITEM.getKey((Object)warp.asItem()).toString());
        }
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("values", (JsonElement)values);
        byte[] data = json.toString().getBytes(StandardCharsets.UTF_8);
        return () -> new ByteArrayInputStream(data);
    }

    private static JsonObject createDoorLootTable(ResourceLocation blockId) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:block");
        JsonObject pool = new JsonObject();
        pool.addProperty("rolls", (Number)1.0);
        pool.addProperty("bonus_rolls", (Number)0.0);
        JsonArray poolConditions = new JsonArray();
        JsonObject survivesExplosion = new JsonObject();
        survivesExplosion.addProperty("condition", "minecraft:survives_explosion");
        poolConditions.add((JsonElement)survivesExplosion);
        pool.add("conditions", (JsonElement)poolConditions);
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "minecraft:item");
        entry.addProperty("name", blockId.toString());
        JsonArray entryConditions = new JsonArray();
        JsonObject blockStateCondition = new JsonObject();
        blockStateCondition.addProperty("block", blockId.toString());
        blockStateCondition.addProperty("condition", "minecraft:block_state_property");
        JsonObject properties = new JsonObject();
        properties.addProperty("half", "lower");
        blockStateCondition.add("properties", (JsonElement)properties);
        entryConditions.add((JsonElement)blockStateCondition);
        entry.add("conditions", (JsonElement)entryConditions);
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        JsonArray pools = new JsonArray();
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        root.addProperty("random_sequence", "marioverse:blocks/" + blockId.getPath());
        return root;
    }

    private static JsonObject createTrapDoorLootTable(ResourceLocation blockId) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:block");
        JsonObject pool = new JsonObject();
        pool.addProperty("rolls", (Number)1.0);
        pool.addProperty("bonus_rolls", (Number)0.0);
        JsonArray poolConditions = new JsonArray();
        JsonObject survivesExplosion = new JsonObject();
        survivesExplosion.addProperty("condition", "minecraft:survives_explosion");
        poolConditions.add((JsonElement)survivesExplosion);
        pool.add("conditions", (JsonElement)poolConditions);
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "minecraft:item");
        entry.addProperty("name", blockId.toString());
        JsonArray entries = new JsonArray();
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        JsonArray pools = new JsonArray();
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        root.addProperty("random_sequence", "marioverse:blocks/" + blockId.getPath());
        return root;
    }
}

