/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.DryBonesEntity;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DryBonesPartEntity
extends Monster
implements GeoEntity,
TraceableEntity {
    public static final RawAnimation SHAKE = RawAnimation.begin().thenLoop("move.shake");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;

    public DryBonesPartEntity(EntityType<? extends DryBonesPartEntity> type, Level world) {
        super(type, world);
        this.xpReward = 1;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.DRY_BONES_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.DRY_BONES_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ItemRegistry.DRY_BONES_SPAWN_EGG.get());
    }

    @NotNull
    public SimpleParticleType getShatterParticle() {
        return ParticleTypes.POOF;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "shake", 5, this::shakeAnimation));
    }

    protected <E extends GeoAnimatable> PlayState shakeAnimation(AnimationState<E> event) {
        int deathDuration = (Integer)this.getData(DataAttachmentRegistry.DEATH_DURATION);
        int reassembleDuration = (Integer)this.getData(DataAttachmentRegistry.REASSEMBLE_DURATION);
        if (!this.isNoAi() && this.getOwnerUUID() != null && deathDuration <= 1 && reassembleDuration < (Integer)ConfigRegistry.DRY_BONES_REASSEMBLE_DURATION.get()) {
            event.setAndContinue(SHAKE);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            tag.putBoolean("LeftOwner", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.leftOwner = tag.getBoolean("LeftOwner");
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
            this.cachedOwner = null;
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void tick() {
        super.tick();
        int deathDuration = (Integer)this.getData(DataAttachmentRegistry.DEATH_DURATION);
        int reassembleDuration = (Integer)this.getData(DataAttachmentRegistry.REASSEMBLE_DURATION);
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (deathDuration > 0) {
            this.setData(DataAttachmentRegistry.DEATH_DURATION, deathDuration - 1);
        }
        if (!this.level().isClientSide && !this.isNoAi() && deathDuration == 0) {
            this.reassembleParts(reassembleDuration);
        }
    }

    public void push(Entity entity) {
        super.push(entity);
        if (!(this.level().isClientSide || this.noPhysics || entity instanceof DryBonesPartEntity)) {
            this.setYRot(this.getYRot() + 8.0f);
            this.yRotO = this.getYRot() + 8.0f;
            this.setYHeadRot(this.getYRot() + 8.0f);
        }
    }

    public void doPush(Entity entity) {
        if (!(entity instanceof DryBonesPartEntity)) {
            super.doPush(entity);
        }
    }

    protected void dropEquipment() {
        if (this.getPartType().equals("left_arm") || this.getPartType().equals("left_leg")) {
            return;
        }
        super.dropEquipment();
    }

    @NotNull
    public AABB makeBoundingBox() {
        return super.makeBoundingBox();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.cachedOwner = serverWorld.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity ownerEntity) {
        if (ownerEntity != null) {
            this.ownerUUID = ownerEntity.getUUID();
            this.cachedOwner = ownerEntity;
        }
    }

    public void setOwnerUUID(@Nullable UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof DryBonesPartEntity) {
            DryBonesPartEntity shell = (DryBonesPartEntity)entity;
            this.cachedOwner = shell.cachedOwner;
        }
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), mob -> !mob.isSpectator() && mob.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public DryBonesEntity getDryBonesEntity() {
        return new DryBonesEntity((EntityType<? extends DryBonesEntity>)((EntityType)EntityRegistry.DRY_BONES.get()), this.level());
    }

    public void setPartType(String type) {
        this.setData(DataAttachmentRegistry.TYPE, type.toLowerCase());
    }

    public String getPartType() {
        return ((String)this.getData(DataAttachmentRegistry.TYPE)).toLowerCase();
    }

    public void reassembleParts(int reassembleDuration) {
        if (reassembleDuration < (Integer)ConfigRegistry.DRY_BONES_REASSEMBLE_DURATION.get()) {
            this.setData(DataAttachmentRegistry.REASSEMBLE_DURATION, reassembleDuration + 1);
        }
        if (reassembleDuration >= (Integer)ConfigRegistry.DRY_BONES_REASSEMBLE_DURATION.get()) {
            this.setData(DataAttachmentRegistry.DEATH_DURATION, -1);
            this.noPhysics = false;
            this.setNoGravity(false);
            return;
        }
        if (this.getOwnerUUID() != null) {
            List parts = this.level().getEntitiesOfClass(DryBonesPartEntity.class, this.getBoundingBox().inflate(32.0), partEntity -> partEntity.getOwnerUUID() != null && this.getOwnerUUID().equals(partEntity.getOwnerUUID()));
            Object shell = null;
            Object head = null;
            for (Object part : parts) {
                if (part.getPartType().equals("shell")) {
                    shell = part;
                }
                if (part.getPartType().equals("head")) {
                    head = part;
                }
                if (this.getPartType().equals("shell")) continue;
                this.noPhysics = true;
                this.setNoGravity(true);
            }
            if (shell != null && head != null) {
                boolean allClose = true;
                for (DryBonesPartEntity part2 : parts) {
                    if (part2 == shell) continue;
                    Vec3 dir = shell.position().subtract(part2.position());
                    double dist = dir.length();
                    double speed = 0.02;
                    Vec3 motion = dir.normalize().scale(speed);
                    if (dist > 0.1) {
                        part2.setDeltaMovement(part2.getDeltaMovement().scale(0.9).add(motion));
                    }
                    if (!(dist > 0.25)) continue;
                    allClose = false;
                }
                if (allClose) {
                    DryBonesPartEntity part2;
                    this.spawnDryBones(parts);
                    part2 = this.level();
                    if (part2 instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)part2;
                        ServerParticleUtils.spawnParticlesOnEntityRandomly((ParticleOptions)this.getShatterParticle(), serverWorld, (Entity)this, 0.0, 15);
                    }
                    this.playSound((SoundEvent)SoundRegistry.DRY_BONES_REASSEMBLE.get());
                    for (DryBonesPartEntity part2 : parts) {
                        part2.discard();
                    }
                }
            }
        }
    }

    private void spawnDryBones(List<DryBonesPartEntity> parts) {
        AccessoriesCapability entityCap;
        if (parts.isEmpty()) {
            return;
        }
        DryBonesEntity entity = parts.getFirst().getDryBonesEntity();
        DryBonesPartEntity partSource = parts.getFirst();
        entity.setPos(partSource.getX(), partSource.getY() + 0.15, partSource.getZ());
        entity.setYRot(partSource.getYRot());
        entity.setXRot(partSource.getXRot());
        entity.yBodyRot = partSource.yBodyRot;
        entity.setYHeadRot(partSource.getYHeadRot());
        entity.setNoAi(partSource.isNoAi());
        entity.setInvulnerable(partSource.isInvulnerable());
        entity.setCustomName(partSource.getCustomName());
        if (partSource.isPersistenceRequired()) {
            entity.setPersistenceRequired();
        }
        if (partSource.getOwner() != null) {
            entity.setUUID(partSource.getOwner().getUUID());
        }
        entity.setData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_SUPER_MUSHROOM));
        entity.setData(DataAttachmentRegistry.HAS_FIRE_FLOWER, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_FIRE_FLOWER));
        entity.setData(DataAttachmentRegistry.HAS_ICE_FLOWER, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_ICE_FLOWER));
        entity.setData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_MEGA_MUSHROOM));
        entity.setData(DataAttachmentRegistry.HAS_MINI_MUSHROOM, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_MINI_MUSHROOM));
        entity.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Boolean)partSource.getData(DataAttachmentRegistry.HAS_SUPER_STAR));
        entity.setData(DataAttachmentRegistry.SUPER_STAR_DURATION, (Integer)partSource.getData(DataAttachmentRegistry.SUPER_STAR_DURATION));
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)Attributes.MAX_HEALTH);
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE);
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)Attributes.SCALE);
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)AttributesRegistry.EYE_HEIGHT_SCALE);
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)AttributesRegistry.HEIGHT_SCALE);
        partSource.copyAttributeWithModifiers((LivingEntity)entity, (Holder<Attribute>)AttributesRegistry.WIDTH_SCALE);
        block0: for (EquipmentSlot slot : EquipmentSlot.values()) {
            for (DryBonesPartEntity part : parts) {
                ItemStack existing;
                ItemStack partStack = part.getItemBySlot(slot);
                if (partStack.isEmpty() || !(existing = entity.getItemBySlot(slot)).isEmpty()) continue;
                entity.setItemSlot(slot, partStack.copy());
                continue block0;
            }
        }
        if (((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue() && !partSource.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP) && (entityCap = AccessoriesCapability.get((LivingEntity)entity)) != null) {
            String[] slotTypes;
            block2: for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                AccessoriesContainer containerEntity = entityCap.getContainer(SlotTypeLoader.getSlotType((LivingEntity)entity, (String)slotType));
                if (containerEntity == null) continue;
                for (DryBonesPartEntity part : parts) {
                    AccessoriesContainer containerPart;
                    AccessoriesCapability partCap = AccessoriesCapability.get((LivingEntity)part);
                    if (partCap == null || (containerPart = partCap.getContainer(SlotTypeLoader.getSlotType((LivingEntity)part, (String)slotType))) == null) continue;
                    ItemStack partStack = containerPart.getAccessories().getItem(0);
                    ItemStack existing = containerEntity.getAccessories().getItem(0);
                    if (partStack.isEmpty() || !existing.isEmpty()) continue;
                    containerEntity.getAccessories().setItem(0, partStack.copy());
                    continue block2;
                }
            }
        }
        partSource.level().addFreshEntity((Entity)entity);
    }

    private void copyAttributeWithModifiers(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance fromAttr = this.getAttribute(attribute);
        AttributeInstance toAttr = entity.getAttribute(attribute);
        if (fromAttr != null && toAttr != null) {
            toAttr.setBaseValue(fromAttr.getBaseValue());
            for (AttributeModifier modifier : fromAttr.getModifiers()) {
                toAttr.addPermanentModifier(modifier);
            }
        }
    }
}

