/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.entities.PokeyEntity;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PokeyBodyEntity
extends PokeyEntity
implements GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;
    public int deathCountdown = 0;

    public PokeyBodyEntity(EntityType<? extends PokeyBodyEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.xpReward = 2;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    public PokeyEntity getPokeyHeadEntity() {
        return (PokeyEntity)((EntityType)EntityRegistry.POKEY.get()).create(this.level());
    }

    public PokeyBodyEntity getPokeyBodyEntity() {
        return (PokeyBodyEntity)((EntityType)EntityRegistry.POKEY_BODY.get()).create(this.level());
    }

    @NotNull
    public Integer getMaxHeightConfig() {
        return (Integer)ConfigRegistry.MAX_POKEY_HEIGHT.get();
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new LookAtTagGoal((Mob)this, this.getCanAttackTag(), 8.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isPassenger()) {
            this.getLookControl().tick();
        }
        if (this.deathCountdown > 0 && this.getHeadSegment() == null && !this.isNoAi()) {
            --this.deathCountdown;
        }
        if (this.getHeadSegment() == null && this.deathCountdown == 0 && !this.isNoAi()) {
            this.kill();
        }
        if (this.isPassenger() && this.getVehicle() instanceof PokeyEntity) {
            LivingEntity bottom = this.getBottomSegment();
            this.setYRot(bottom.getYRot());
            this.yRotO = bottom.yRotO;
            this.setYHeadRot(bottom.getYHeadRot());
            this.yHeadRotO = bottom.yHeadRotO;
        }
    }

    @Override
    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    @Override
    public void setRemainingPersistentAngerTime(int angerTime) {
        this.remainingPersistentAngerTime = angerTime;
    }

    @Override
    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    @Override
    public void setPersistentAngerTarget(@Nullable UUID angerTarget) {
        this.persistentAngerTarget = angerTarget;
    }

    @Override
    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.spawnPokeyStack(serverWorld.getLevel(), difficulty, spawnType);
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    private void spawnPokeyStack(ServerLevel serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType) {
        PokeyBodyEntity body;
        double nextZ;
        double nextY;
        double nextX;
        BlockPos pos;
        BlockState state;
        RandomSource random = serverWorld.getRandom();
        int bodyCount = random.nextInt(this.getMaxHeightConfig().intValue());
        PokeyBodyEntity currentTop = this;
        if (!currentTop.getPassengers().isEmpty()) {
            return;
        }
        for (int i = 0; i < bodyCount - 1 && !(state = serverWorld.getBlockState(pos = BlockPos.containing((double)(nextX = currentTop.getX()), (double)(nextY = currentTop.getY() + (double)currentTop.getBbHeight()), (double)(nextZ = currentTop.getZ())))).isSolid() && currentTop.getPassengers().isEmpty() && (body = this.getPokeyBodyEntity()).getPassengers().isEmpty(); ++i) {
            body.moveTo(nextX, nextY, nextZ, this.getYRot(), this.getXRot());
            body.startRiding((Entity)currentTop, true);
            body.deathCountdown = 2;
            currentTop = body;
        }
        PokeyEntity head = this.getPokeyHeadEntity();
        double x = currentTop.getX();
        double y = currentTop.getY() + (double)currentTop.getBbHeight();
        double z = currentTop.getZ();
        pos = BlockPos.containing((double)x, (double)y, (double)z);
        while (serverWorld.getBlockState(pos).isSolid()) {
            pos = BlockPos.containing((double)x, (double)(y += 1.0), (double)z);
        }
        head.moveTo(x, y, z, this.getYRot(), this.getXRot());
        head.finalizeSpawn((ServerLevelAccessor)serverWorld, difficulty, spawnType, null);
        head.startRiding((Entity)currentTop, true);
    }
}

