/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.mojang.authlib.GameProfile;
import com.wenxin2.marioverse.entities.PiranhaPlantEntity;
import com.wenxin2.marioverse.entities.PokeyBodyEntity;
import com.wenxin2.marioverse.entities.SnowPokeyBodyEntity;
import com.wenxin2.marioverse.entities.SnowPokeyEntity;
import com.wenxin2.marioverse.entities.ai.goals.LookAtTagGoal;
import com.wenxin2.marioverse.integration.CompatRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PokeyEntity
extends Monster
implements GeoEntity,
NeutralMob,
IShearable {
    public static final RawAnimation EMERGE = RawAnimation.begin().thenPlayAndHold("misc.emerge");
    public static final RawAnimation HIDE = RawAnimation.begin().thenPlayAndHold("misc.hide");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    public static final RawAnimation WALK_INVERSE = RawAnimation.begin().thenLoop("move.walk_inverse");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private RawAnimation currentAnimation = null;
    public int attackCooldown = 0;
    private boolean hasBloomed = false;

    public PokeyEntity(EntityType<? extends PokeyEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.DOOR_OPEN, 1.0f);
        this.xpReward = 2;
    }

    public int getAmbientSoundInterval() {
        return 360;
    }

    @NotNull
    public DamageSource getDamageSource(Entity collidingEntity) {
        return DamageSourceRegistry.pokeyThorns(collidingEntity);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new LookAtTagGoal((Mob)this, this.getCanAttackTag(), 8.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public TagKey<EntityType<?>> getCanAttackTag() {
        return TagRegistry.POKEY_CAN_ATTACK;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk", 5, this::walkController));
        controllers.add(new AnimationController((GeoAnimatable)this, "bloom_controller", 5, state -> PlayState.STOP).triggerableAnim("bloom", EMERGE));
        controllers.add(new AnimationController((GeoAnimatable)this, "hide_controller", 5, state -> PlayState.STOP).triggerableAnim("hide", HIDE));
    }

    /*
     * Unable to fully structure code
     */
    protected <E extends GeoAnimatable> PlayState walkController(AnimationState<E> event) {
        bottomPokey = this.getBottomSegment();
        if (bottomPokey == this) {
            if (this.getDeltaMovement().horizontalDistance() > 0.001) {
                event.setAndContinue(PokeyEntity.WALK);
                this.setCurrentAnimation(PokeyEntity.WALK);
                return PlayState.CONTINUE;
            }
            this.setCurrentAnimation(null);
            return PlayState.STOP;
        }
        var4_3 = this.getVehicle();
        if (!(var4_3 instanceof PokeyEntity)) ** GOTO lbl-1000
        pokeyVehicle = (PokeyEntity)var4_3;
        if (bottomPokey.getDeltaMovement().horizontalDistance() > 0.001) {
            if (pokeyVehicle.getCurrentAnimation() == PokeyEntity.WALK) {
                this.setCurrentAnimation(PokeyEntity.WALK_INVERSE);
                event.setAndContinue(PokeyEntity.WALK_INVERSE);
                return PlayState.CONTINUE;
            }
            if (pokeyVehicle.getCurrentAnimation() == PokeyEntity.WALK_INVERSE) {
                this.setCurrentAnimation(PokeyEntity.WALK);
                event.setAndContinue(PokeyEntity.WALK);
                return PlayState.CONTINUE;
            }
        } else lbl-1000:
        // 2 sources

        {
            this.setCurrentAnimation(null);
        }
        this.setCurrentAnimation(null);
        return PlayState.STOP;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public RawAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public void setCurrentAnimation(RawAnimation anim) {
        this.currentAnimation = anim;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readPersistentAngerSaveData(this.level(), tag);
    }

    public void tick() {
        super.tick();
        this.pokeEntity();
        this.triggerBloom();
        if (!this.hasData(DataAttachmentRegistry.HAS_FLOWER.get()) && !(this instanceof PokeyBodyEntity)) {
            this.setData(DataAttachmentRegistry.HAS_FLOWER, false);
        }
        if (!this.hasData(DataAttachmentRegistry.IS_BLOOMING)) {
            this.setData(DataAttachmentRegistry.IS_BLOOMING, false);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        LivingEntity head = this.getHeadSegment();
        if (this.isPassenger() && this == head) {
            LivingEntity bottom = this.getBottomSegment();
            this.setYHeadRot(bottom.getYHeadRot());
            this.yHeadRotO = bottom.yHeadRotO;
        }
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level world = this.level();
        ItemStack stack = player.getItemInHand(hand);
        if (stack.is(Tags.Items.TOOLS_SHEAR) && this.isShearable(player, stack, world, this.blockPosition()) && !(this instanceof PokeyBodyEntity)) {
            this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            this.onSheared(player, stack, world, this.blockPosition());
            if (!world.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, PokeyEntity.getSlotForHand((InteractionHand)hand));
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public boolean hurt(DamageSource source, float amount) {
        Entity attacker;
        if (!this.level().isClientSide() && super.hurt(source, amount) && (attacker = source.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            LivingEntity headEntity = this.getHeadSegment();
            if (headEntity != this && headEntity instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)headEntity;
                neutralMob.setPersistentAngerTarget(livingEntity.getUUID());
                neutralMob.startPersistentAngerTimer();
                neutralMob.setTarget(livingEntity);
            }
            this.setPersistentAngerTarget(livingEntity.getUUID());
            this.startPersistentAngerTimer();
            this.setTarget(livingEntity);
        }
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        super.die(source);
        Entity vehicle = this.getVehicle();
        while (vehicle instanceof PokeyEntity) {
            Entity next = vehicle.getVehicle();
            vehicle.kill();
            vehicle = next;
        }
    }

    public void knockback(double strength, double x, double z) {
        LivingEntity bottom = this.getBottomSegment();
        if (bottom == this) {
            super.knockback(strength, x, z);
            return;
        }
        if (bottom instanceof LivingEntity) {
            LivingEntity livingEntity = bottom;
            livingEntity.knockback(strength, x, z);
        }
    }

    public void travel(Vec3 travelVector) {
        if (this.isVehicle() && this.isInWater() && this.getFluidHeight(FluidTags.WATER) > this.getFluidJumpThreshold()) {
            if (this.getRandom().nextFloat() < 0.8f) {
                this.getJumpControl().jump();
            }
            this.getNavigation().setCanFloat(true);
        }
        super.travel(travelVector);
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.remainingPersistentAngerTime = angerTime;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID angerTarget) {
        this.persistentAngerTarget = angerTarget;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public ItemStack getPickedResult(@NotNull HitResult target) {
        return new ItemStack((ItemLike)ItemRegistry.POKEY_SPAWN_EGG.get());
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        if (!(this instanceof PokeyBodyEntity) && this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            if (random.nextFloat() < 0.015f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.DIAMOND_HELMET));
            } else if (random.nextFloat() < 0.05f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.IRON_HELMET));
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverWorld, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        RandomSource random = serverWorld.getRandom();
        this.populateDefaultEquipmentSlots(random, difficulty);
        this.populateDefaultEquipmentEnchantments(serverWorld, random, difficulty);
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localDate = LocalDate.now();
            int day = localDate.getDayOfMonth();
            int month = localDate.getMonth().getValue();
            List players = serverWorld.getLevel().players();
            boolean isHalloween = month == 10 && day >= 30 && (Boolean)ConfigRegistry.DISABLE_MOB_MASKS.get() == false;
            boolean forceMasks = (Boolean)ConfigRegistry.FORCE_MOB_MASKS.get();
            Optional<Item> randomMask = BuiltInRegistries.ITEM.getTag(TagRegistry.HALLOWEEN_MASKS).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value);
            if (isHalloween || forceMasks) {
                ArrayList skulls;
                boolean appliedMask = false;
                if (random.nextFloat() < 0.25f) {
                    randomMask.ifPresent(item -> this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item)));
                    appliedMask = this.getItemBySlot(EquipmentSlot.HEAD).is(TagRegistry.HALLOWEEN_MASKS);
                }
                if (random.nextFloat() < 0.15f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.ITEM).getTagOrEmpty(ItemTags.SKULLS).forEach(holder -> {
                        Item item = (Item)holder.value();
                        skulls.add(new ItemStack((ItemLike)item));
                    });
                    if (!skulls.isEmpty()) {
                        ItemStack randomSkull = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        if (randomSkull.getItem() instanceof PlayerHeadItem && !players.isEmpty()) {
                            ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                            GameProfile playerProfile = randomPlayer.getGameProfile();
                            ItemStack playerHead = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                            playerHead.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                            this.setItemSlot(EquipmentSlot.HEAD, playerHead);
                        } else {
                            this.setItemSlot(EquipmentSlot.HEAD, randomSkull);
                        }
                        appliedMask = true;
                    }
                }
                if (random.nextFloat() < 0.1f && !players.isEmpty()) {
                    ServerPlayer randomPlayer = (ServerPlayer)players.get(random.nextInt(players.size()));
                    GameProfile playerProfile = randomPlayer.getGameProfile();
                    SkullBlockEntity.fetchGameProfile((UUID)randomPlayer.getUUID());
                    ItemStack playerHeadItem = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                    playerHeadItem.set(DataComponents.PROFILE, (Object)new ResolvableProfile(playerProfile));
                    this.setItemSlot(EquipmentSlot.HEAD, playerHeadItem);
                    appliedMask = true;
                }
                if (random.nextFloat() < 0.05f) {
                    skulls = new ArrayList();
                    serverWorld.registryAccess().registryOrThrow(Registries.BLOCK).getTagOrEmpty(CompatRegistry.TF_TROPHIES).forEach(holder -> skulls.add(new ItemStack((ItemLike)holder.value())));
                    if (!skulls.isEmpty()) {
                        ItemStack randomTrophy = (ItemStack)skulls.get(random.nextInt(skulls.size()));
                        this.setItemSlot(EquipmentSlot.HEAD, randomTrophy);
                        appliedMask = true;
                    }
                }
                if (appliedMask) {
                    this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
                }
            }
        }
        return super.finalizeSpawn(serverWorld, difficulty, spawnType, groupData);
    }

    public static boolean checkPokeySpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return serverWorld.getDifficulty() != Difficulty.PEACEFUL && (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || PokeyEntity.isDarkEnoughToSpawn((ServerLevelAccessor)serverWorld, (BlockPos)pos, (RandomSource)random)) && PokeyEntity.checkMobSpawnRules(entityType, (LevelAccessor)serverWorld, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, ItemStack stack, Level world, BlockPos pos) {
        List defaultDrops = super.onSheared(player, stack, world, pos);
        ArrayList<ItemStack> finalDrops = new ArrayList<ItemStack>(defaultDrops);
        LivingEntity headEntity = this.getHeadSegment();
        if (!world.isClientSide() && ((Boolean)this.getData(DataAttachmentRegistry.HAS_FLOWER.get())).booleanValue() && !(this instanceof PokeyBodyEntity)) {
            world.playSound(null, (Entity)this, SoundEvents.MOOSHROOM_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.setData(DataAttachmentRegistry.HAS_FLOWER, false);
            this.spawnShearedDrop(world, pos, new ItemStack(BlockRegistry.DANGO_BLOSSOM));
            finalDrops.add(new ItemStack(BlockRegistry.DANGO_BLOSSOM));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, this.blockPosition(), stack);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        }
        if (headEntity != this && headEntity instanceof NeutralMob) {
            NeutralMob neutralMob = (NeutralMob)headEntity;
            neutralMob.setPersistentAngerTarget(player.getUUID());
            neutralMob.startPersistentAngerTimer();
            neutralMob.setTarget((LivingEntity)player);
        }
        this.setPersistentAngerTarget(player.getUUID());
        this.startPersistentAngerTimer();
        this.setTarget((LivingEntity)player);
        return finalDrops;
    }

    public boolean isShearable(@Nullable Player player, ItemStack stack, Level world, BlockPos pos) {
        return super.isShearable(player, stack, world, pos) && this.isAlive() && (Boolean)this.getData(DataAttachmentRegistry.HAS_FLOWER) != false;
    }

    public void triggerBloom() {
        if (this instanceof SnowPokeyEntity || this instanceof SnowPokeyBodyEntity) {
            return;
        }
        int frequency = (Integer)ConfigRegistry.POKEY_BLOOM_FREQUENCY.get();
        int duration = (Integer)ConfigRegistry.POKEY_BLOOM_DURATION.get();
        boolean infinite = frequency == 0;
        boolean isValid = duration != 0 && frequency > duration;
        long time = this.level().getGameTime();
        long phase = infinite ? 0L : time % (long)frequency;
        boolean shouldBloomAnim = infinite || isValid && phase < (long)duration;
        boolean shouldBloom = infinite || isValid && phase - 10L < (long)(duration + 10) && frequency - 10 > duration + 10;
        boolean currentBloom = (Boolean)this.getData(DataAttachmentRegistry.IS_BLOOMING);
        if (shouldBloomAnim != currentBloom || !this.hasBloomed) {
            this.triggerAnim(shouldBloomAnim ? "bloom_controller" : "hide_controller", shouldBloomAnim ? "bloom" : "hide");
            this.stopTriggeredAnim(shouldBloomAnim ? "hide_controller" : "bloom_controller", shouldBloomAnim ? "hide" : "bloom");
        }
        if (shouldBloom != currentBloom || !this.hasBloomed) {
            this.setData(DataAttachmentRegistry.IS_BLOOMING, shouldBloom);
            if (!(this instanceof PokeyBodyEntity)) {
                this.setData(DataAttachmentRegistry.HAS_FLOWER, shouldBloom);
            }
            this.hasBloomed = true;
        }
    }

    public void pokeEntity() {
        if (this.attackCooldown > 0 || !this.isAlive() || ((Boolean)this.getData(DataAttachmentRegistry.IS_BLOOMING)).booleanValue()) {
            return;
        }
        List nearbyEntities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.01, 0.0, 0.01), entity -> !entity.isSpectator() && entity instanceof LivingEntity && !(entity instanceof PiranhaPlantEntity) && !this.level().isClientSide());
        if (!nearbyEntities.isEmpty()) {
            for (Entity collidingEntity : nearbyEntities) {
                Player player;
                if (collidingEntity instanceof PokeyEntity || collidingEntity.getType().is(TagRegistry.THORNS_IMMUNE) || collidingEntity.isSpectator() || collidingEntity instanceof Player && (player = (Player)collidingEntity).isCreative()) continue;
                float attackDamage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
                if (collidingEntity instanceof Creeper) {
                    collidingEntity.hurt(this.getDamageSource(collidingEntity), attackDamage);
                } else {
                    collidingEntity.hurt(this.getDamageSource((Entity)this), attackDamage);
                }
                if (collidingEntity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)collidingEntity;
                    neutralMob.isAngryAt((LivingEntity)this);
                    neutralMob.setTarget((LivingEntity)this);
                    neutralMob.setPersistentAngerTarget(this.getUUID());
                }
                this.attackCooldown = 20;
                break;
            }
        }
    }

    @Nullable
    public LivingEntity getHeadSegment() {
        Entity entity;
        PokeyEntity current = this;
        while ((entity = current.getFirstPassenger()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            current = livingEntity;
        }
        if (current instanceof PokeyBodyEntity) {
            return null;
        }
        return current;
    }

    public LivingEntity getBottomSegment() {
        Entity entity;
        PokeyEntity current = this;
        while ((entity = current.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            current = livingEntity;
        }
        return current;
    }

    public List<PokeyEntity> getEntireStack() {
        Entity entity;
        ArrayList<PokeyEntity> result = new ArrayList<PokeyEntity>();
        PokeyEntity bottom = this;
        while ((entity = bottom.getVehicle()) instanceof PokeyEntity) {
            PokeyEntity pe;
            bottom = pe = (PokeyEntity)entity;
        }
        PokeyEntity current = bottom;
        while (current != null) {
            result.add(current);
            current = current.getPassengers().stream().filter(p -> p instanceof PokeyEntity).map(p -> (PokeyEntity)((Object)p)).findFirst().orElse(null);
        }
        return result;
    }
}

