/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public interface WarpLinkableEntity {
    public static final Map<UUID, WarpTarget> WARP_LOCATIONS = new HashMap<UUID, WarpTarget>();
    public static final Map<BlockPos, Entity> WARP_ENTITY_LOCATIONS = new HashMap<BlockPos, Entity>();
    public static final Map<Integer, Boolean> WARPED_ENTITIES = new HashMap<Integer, Boolean>();

    public boolean mv$isWaxed();

    public void mv$setWaxed(boolean var1);

    public boolean mv$hasDestinationPos();

    public void mv$setDestinationPos(@Nullable BlockPos var1);

    public BlockPos mv$getDestinationPos();

    public ResourceKey<Level> mv$getDestinationDim();

    public void mv$setDestinationDim(@Nullable ResourceKey<Level> var1);

    public int mv$getWarpFuelCount();

    public void mv$setWarpFuelCount(int var1);

    public boolean mv$isBreakPainting();

    public void mv$setBreakPainting(boolean var1);

    public boolean mv$getPreventWarp();

    public void mv$setPreventWarp(boolean var1);

    public UUID mv$getWarpUUID();

    public void mv$setWarpUuid(UUID var1);

    public Entity mv$getWarpEntity();

    public void mv$setWarpEntity(Entity var1);

    @Nullable
    public static WarpTarget getWarpPos(UUID uuid) {
        return WARP_LOCATIONS.get(uuid);
    }

    public static void setWarpPos(UUID uuid, BlockPos pos, Direction direction, int width) {
        WARP_LOCATIONS.put(uuid, new WarpTarget(pos, direction, width));
    }

    public static void markEntityTeleported(Entity entity) {
        if (entity != null) {
            WARPED_ENTITIES.put(entity.getId(), true);
        }
    }

    public static void warp(Entity entity, double x, double y, double z, Level world) {
        LivingEntity passengerEntity = entity.getControllingPassenger();
        if (!((Boolean)entity.getData(DataAttachmentRegistry.PREVENT_WARP)).booleanValue()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                entity.teleportTo(x, y, z);
                entity.setData(DataAttachmentRegistry.WARP_COOLDOWN, (Object)((Integer)ConfigRegistry.WARP_PAINTING_COOLDOWN.get()));
                if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                    player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                }
            } else {
                entity.teleportTo(x, y, z);
                entity.setData(DataAttachmentRegistry.WARP_COOLDOWN, (Object)((Integer)ConfigRegistry.WARP_PAINTING_COOLDOWN.get()));
                if (passengerEntity instanceof Player) {
                    Player player = (Player)passengerEntity;
                    if (((Boolean)ConfigRegistry.BLINDNESS_EFFECT.get()).booleanValue() && !world.isClientSide()) {
                        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 20, 0, true, false));
                    }
                    entity.unRide();
                }
            }
        }
        WarpLinkableEntity.markEntityTeleported(entity);
        world.gameEvent((Holder)GameEvent.TELEPORT, BlockPos.containing((double)x, (double)y, (double)z), GameEvent.Context.of((Entity)entity));
        world.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)SoundRegistry.PAINTING_WARPS.get(), SoundSource.BLOCKS);
    }

    public record WarpTarget(BlockPos pos, Direction direction, int width) {
    }
}

