/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities.ai.goals;

import com.wenxin2.marioverse.blocks.CoinBlock;
import com.wenxin2.marioverse.blocks.StarCoinBlock;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class CollectBlockGoal
extends Goal {
    private final Mob mob;
    private final double speedModifier;
    private final int searchRadius;
    private final float activationChance;
    private final Predicate<BlockState> targetBlockState;
    private BlockPos targetPos;
    private int nextStartTick = 0;
    private static final int COOLDOWN = 200;

    public CollectBlockGoal(Mob mob, float activationChance, int searchRadius, double speedModifier, Predicate<BlockState> targetBlockState) {
        this.mob = mob;
        this.activationChance = activationChance;
        this.searchRadius = searchRadius;
        this.speedModifier = speedModifier;
        this.targetBlockState = targetBlockState;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.nextStartTick == 0) {
            this.targetPos = this.findBlock();
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (!EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
            return false;
        }
        if (this.mob.getRandom().nextFloat() >= this.activationChance) {
            this.nextStartTick = 200;
            return false;
        }
        if (this.targetPos == null) {
            this.nextStartTick = 200;
            return false;
        }
        return true;
    }

    public void start() {
        if (this.targetPos != null) {
            this.mob.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY(), (double)this.targetPos.getZ() + 0.5, this.speedModifier);
        }
    }

    public boolean canContinueToUse() {
        return this.targetPos != null && !this.mob.getNavigation().isDone();
    }

    public void tick() {
        if (this.targetPos != null) {
            this.mob.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), this.speedModifier);
            if (this.mob.blockPosition().closerToCenterThan((Position)Vec3.atCenterOf((Vec3i)this.targetPos), (double)this.mob.getBbWidth() + 1.2)) {
                this.collectBlock();
                this.targetPos = null;
                this.nextStartTick = 200;
            }
        }
    }

    private BlockPos findBlock() {
        BlockPos mobPos = this.mob.blockPosition();
        Level world = this.mob.level();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)mobPos.offset(-this.searchRadius, -2, -this.searchRadius), (BlockPos)mobPos.offset(this.searchRadius, 2, this.searchRadius))) {
            if (!this.targetBlockState.test(world.getBlockState(pos))) continue;
            return pos.immutable();
        }
        return null;
    }

    private void collectBlock() {
        block2: {
            Mob inventory;
            ItemStack stack;
            block7: {
                block6: {
                    block5: {
                        BlockState state;
                        Level world;
                        block4: {
                            block3: {
                                world = this.mob.level();
                                state = world.getBlockState(this.targetPos);
                                stack = new ItemStack((ItemLike)state.getBlock().asItem());
                                if (!this.targetBlockState.test(state)) break block2;
                                Block block = state.getBlock();
                                if (!(block instanceof StarCoinBlock)) break block3;
                                StarCoinBlock starCoinBlock = (StarCoinBlock)block;
                                StarCoinBlock.collectCoin(starCoinBlock, world, state, this.targetPos, (Entity)this.mob, stack);
                                break block2;
                            }
                            if (!(state.getBlock() instanceof CoinBlock)) break block4;
                            CoinBlock.collectCoin(world, state, this.targetPos, (Entity)this.mob, stack);
                            break block2;
                        }
                        world.destroyBlock(this.targetPos, false);
                        world.playSound((Entity)this.mob, this.targetPos, state.getBlock().asItem().getBreakingSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        if (!this.mob.getMainHandItem().isEmpty()) break block5;
                        this.mob.setItemInHand(InteractionHand.MAIN_HAND, stack);
                        this.mob.swing(InteractionHand.MAIN_HAND);
                        break block2;
                    }
                    if (!this.mob.getOffhandItem().isEmpty()) break block6;
                    this.mob.setItemInHand(InteractionHand.OFF_HAND, stack);
                    this.mob.swing(InteractionHand.OFF_HAND);
                    break block2;
                }
                Mob mob = this.mob;
                if (!(mob instanceof InventoryCarrier)) break block7;
                InventoryCarrier carrier = (InventoryCarrier)mob;
                inventory = carrier.getInventory();
                this.mob.swing(InteractionHand.MAIN_HAND);
                for (int i = 0; i < inventory.getContainerSize(); ++i) {
                    if (!inventory.getItem(i).isEmpty()) continue;
                    inventory.setItem(i, stack);
                    break block2;
                }
                break block2;
            }
            inventory = this.mob;
            if (!(inventory instanceof Container)) break block2;
            Container container = (Container)inventory;
            this.mob.swing(InteractionHand.MAIN_HAND);
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.getItem(i).isEmpty()) continue;
                container.setItem(i, stack);
                break;
            }
        }
    }
}

